/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import org.jboss.logging.Logger;
import org.keycloak.common.ClientConnection;
import org.keycloak.common.util.Time;
import org.keycloak.events.EventBuilder;
import org.keycloak.events.EventType;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.KeycloakSessionFactory;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.ServicesLogger;
import org.keycloak.services.managers.BruteForceProtector;

public class DefaultBruteForceProtector
implements Runnable,
BruteForceProtector {
    private static final Logger logger = Logger.getLogger(DefaultBruteForceProtector.class);
    protected volatile boolean run = true;
    protected int maxDeltaTimeSeconds = 43200;
    protected KeycloakSessionFactory factory;
    protected CountDownLatch shutdownLatch = new CountDownLatch(1);
    protected volatile long failures;
    protected volatile long lastFailure;
    protected volatile long totalTime;
    protected LinkedBlockingQueue<LoginEvent> queue = new LinkedBlockingQueue();
    public static final int TRANSACTION_SIZE = 20;

    public DefaultBruteForceProtector(KeycloakSessionFactory factory) {
        this.factory = factory;
    }

    protected void failure(KeycloakSession session, LoginEvent event) {
        logger.debug((Object)"failure");
        RealmModel realm = this.getRealmModel(session, event);
        this.logFailure(event);
        String userId = event.userId;
        UserLoginFailureModel userLoginFailure = this.getUserModel(session, event);
        if (userLoginFailure == null) {
            userLoginFailure = session.loginFailures().addUserLoginFailure(realm, userId);
        }
        userLoginFailure.setLastIPFailure(event.clientConnection.getRemoteAddr());
        long currentTime = Time.currentTimeMillis();
        long last = userLoginFailure.getLastFailure();
        long deltaTime = 0L;
        if (last > 0L) {
            deltaTime = currentTime - last;
        }
        userLoginFailure.setLastFailure(currentTime);
        if (deltaTime > 0L && deltaTime > (long)realm.getMaxDeltaTimeSeconds() * 1000L) {
            userLoginFailure.clearFailures();
        }
        userLoginFailure.incrementFailures();
        logger.debugv("new num failures: {0}", (Object)userLoginFailure.getNumFailures());
        int waitSeconds = realm.getWaitIncrementSeconds() * (userLoginFailure.getNumFailures() / realm.getFailureFactor());
        logger.debugv("waitSeconds: {0}", (Object)waitSeconds);
        logger.debugv("deltaTime: {0}", (Object)deltaTime);
        boolean quickLoginFailure = false;
        if (waitSeconds == 0 && last > 0L && deltaTime < realm.getQuickLoginCheckMilliSeconds()) {
            logger.debugv("quick login, set min wait seconds", new Object[0]);
            waitSeconds = realm.getMinimumQuickLoginWaitSeconds();
            quickLoginFailure = true;
        }
        if (waitSeconds > 0) {
            if (!realm.isPermanentLockout() || realm.getMaxTemporaryLockouts() > 0) {
                waitSeconds = Math.min(realm.getMaxFailureWaitSeconds(), waitSeconds);
            }
            if (!quickLoginFailure) {
                userLoginFailure.incrementTemporaryLockouts();
            }
            if (quickLoginFailure || !realm.isPermanentLockout() || userLoginFailure.getNumTemporaryLockouts() <= realm.getMaxTemporaryLockouts()) {
                int notBefore = (int)(currentTime / 1000L) + waitSeconds;
                logger.debugv("set notBefore: {0}", (Object)notBefore);
                userLoginFailure.setFailedLoginNotBefore(notBefore);
                this.sendEvent(session, realm, userLoginFailure, EventType.USER_DISABLED_BY_TEMPORARY_LOCKOUT);
            }
        }
        if (!realm.isPermanentLockout()) {
            return;
        }
        if (userLoginFailure.getNumTemporaryLockouts() > realm.getMaxTemporaryLockouts()) {
            UserModel user = session.users().getUserById(realm, userId);
            if (user == null) {
                return;
            }
            logger.debugv("user {0} locked permanently due to too many login attempts", (Object)user.getUsername());
            user.setEnabled(false);
            user.setSingleAttribute("disabledReason", "permanentLockout");
            this.sendEvent(session, realm, userLoginFailure, EventType.USER_DISABLED_BY_PERMANENT_LOCKOUT);
        }
    }

    protected UserLoginFailureModel getUserModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = this.getRealmModel(session, event);
        if (realm == null) {
            return null;
        }
        UserLoginFailureModel user = session.loginFailures().getUserLoginFailure(realm, event.userId);
        if (user == null) {
            return null;
        }
        return user;
    }

    protected RealmModel getRealmModel(KeycloakSession session, LoginEvent event) {
        RealmModel realm = session.realms().getRealm(event.realmId);
        if (realm == null) {
            return null;
        }
        return realm;
    }

    protected void sendEvent(KeycloakSession session, RealmModel realm, UserLoginFailureModel userLoginFailure, EventType type) {
        EventBuilder builder = new EventBuilder(realm, session).ipAddress(userLoginFailure.getLastIPFailure()).event(type).detail("reason", "brute_force_attack detected").detail("num_failures", String.valueOf(userLoginFailure.getNumFailures())).user(userLoginFailure.getUserId());
        if (type == EventType.USER_DISABLED_BY_TEMPORARY_LOCKOUT) {
            long secondsSinceEpoch = userLoginFailure.getFailedLoginNotBefore();
            Instant instant = Instant.ofEpochSecond(secondsSinceEpoch);
            LocalDateTime timestamp = LocalDateTime.ofInstant(instant, ZoneId.systemDefault());
            builder.detail("not_before", timestamp.toString());
        }
        builder.success();
    }

    public void start() {
        new Thread((Runnable)this, "Brute Force Protector").start();
    }

    public void shutdown() {
        this.run = false;
        try {
            this.queue.offer(new ShutdownEvent());
            this.shutdownLatch.await(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        block27: {
            events = new ArrayList<LoginEvent>(21);
            while (true) lbl-1000:
            // 3 sources

            {
                if (this.run == false) return;
                try {
                    take = this.queue.poll(2L, TimeUnit.SECONDS);
                    if (take == null) ** GOTO lbl-1000
                    try {
                        events.add(take);
                        this.queue.drainTo(events, 20);
                        Collections.sort(events);
                        try {
                            session = this.factory.create();
                            try {
                                session.getTransactionManager().begin();
                                try {
                                    for (LoginEvent event : events) {
                                        if (event instanceof FailedLogin) {
                                            this.failure((KeycloakSession)session, event);
                                            continue;
                                        }
                                        if (event instanceof SuccessfulLogin) {
                                            this.success((KeycloakSession)session, event);
                                            continue;
                                        }
                                        if (!(event instanceof ShutdownEvent)) continue;
                                        this.run = false;
                                    }
                                }
                                catch (Exception e) {
                                    session.getTransactionManager().setRollbackOnly();
                                    throw e;
                                }
                            }
                            finally {
                                if (session != null) {
                                    session.close();
                                }
                            }
                            session = events.iterator();
                            break block27;
                        }
                        catch (Throwable var6_11) {
                            var7_12 = events.iterator();
                            while (true) {
                                if (!var7_12.hasNext()) {
                                    events.clear();
                                    throw var6_11;
                                }
                                event = (LoginEvent)var7_12.next();
                                if (event instanceof FailedLogin) {
                                    ((FailedLogin)event).latch.countDown();
                                    continue;
                                }
                                if (!(event instanceof SuccessfulLogin)) continue;
                                ((SuccessfulLogin)event).latch.countDown();
                            }
                        }
                    }
                    catch (Exception e) {
                        ServicesLogger.LOGGER.failedProcessingType(e);
                    }
                }
                catch (InterruptedException e) {
                    // empty catch block
                    return;
                }
                break;
            }
            finally {
                this.shutdownLatch.countDown();
            }
        }
        while (session.hasNext()) {
            event = (LoginEvent)session.next();
            if (event instanceof FailedLogin) {
                ((FailedLogin)event).latch.countDown();
                continue;
            }
            if (!(event instanceof SuccessfulLogin)) continue;
            ((SuccessfulLogin)event).latch.countDown();
        }
        events.clear();
        ** continue;
    }

    protected void success(KeycloakSession session, LoginEvent event) {
        String userId = event.userId;
        UserLoginFailureModel user = this.getUserModel(session, event);
        if (user == null) {
            return;
        }
        if (logger.isDebugEnabled()) {
            UserModel model = session.users().getUserById(this.getRealmModel(session, event), userId);
            logger.debugv("user {0} successfully logged in, clearing all failures", (Object)model.getUsername());
        }
        user.clearFailures();
    }

    protected void logFailure(LoginEvent event) {
        ++this.failures;
        long delta = 0L;
        if (this.lastFailure > 0L) {
            delta = Time.currentTimeMillis() - this.lastFailure;
            this.totalTime = delta > (long)this.maxDeltaTimeSeconds * 1000L ? 0L : (this.totalTime += delta);
        }
    }

    public void failedLogin(RealmModel realm, UserModel user, ClientConnection clientConnection) {
        try {
            FailedLogin event = new FailedLogin(realm.getId(), user.getId(), clientConnection);
            this.queue.offer(event);
            event.latch.await(5L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        logger.trace((Object)"sent failure event");
    }

    public void successfulLogin(RealmModel realm, UserModel user, ClientConnection clientConnection) {
        SuccessfulLogin event = new SuccessfulLogin(realm.getId(), user.getId(), clientConnection);
        this.queue.offer(event);
        logger.trace((Object)"sent success event");
    }

    public boolean isTemporarilyDisabled(KeycloakSession session, RealmModel realm, UserModel user) {
        int failedLoginNotBefore;
        int currTime;
        UserLoginFailureModel failure = session.loginFailures().getUserLoginFailure(realm, user.getId());
        if (failure != null && (currTime = (int)(Time.currentTimeMillis() / 1000L)) < (failedLoginNotBefore = failure.getFailedLoginNotBefore())) {
            logger.debugv("Current: {0} notBefore: {1}", (Object)currTime, (Object)failedLoginNotBefore);
            return true;
        }
        return false;
    }

    public boolean isPermanentlyLockedOut(KeycloakSession session, RealmModel realm, UserModel user) {
        return !user.isEnabled() && "permanentLockout".equals(user.getFirstAttribute("disabledReason"));
    }

    public void cleanUpPermanentLockout(KeycloakSession session, RealmModel realm, UserModel user) {
        if ("permanentLockout".equals(user.getFirstAttribute("disabledReason"))) {
            user.removeAttribute("disabledReason");
        }
    }

    public void close() {
    }

    protected abstract class LoginEvent
    implements Comparable<LoginEvent> {
        protected final String realmId;
        protected final String userId;
        protected final ClientConnection clientConnection;

        protected LoginEvent(String realmId, String userId, ClientConnection clientConnection) {
            this.realmId = realmId;
            this.userId = userId;
            this.clientConnection = new AdaptedClientConnection(clientConnection);
        }

        @Override
        public int compareTo(LoginEvent o) {
            return this.userId.compareTo(o.userId);
        }
    }

    protected class ShutdownEvent
    extends LoginEvent {
        public ShutdownEvent() {
            super(null, null, null);
        }
    }

    protected class FailedLogin
    extends LoginEvent {
        protected final CountDownLatch latch;

        public FailedLogin(String realmId, String userId, ClientConnection clientConnection) {
            super(realmId, userId, clientConnection);
            this.latch = new CountDownLatch(1);
        }
    }

    protected class SuccessfulLogin
    extends LoginEvent {
        protected final CountDownLatch latch;

        public SuccessfulLogin(String realmId, String userId, ClientConnection clientConnection) {
            super(realmId, userId, clientConnection);
            this.latch = new CountDownLatch(1);
        }
    }

    protected static class AdaptedClientConnection
    implements ClientConnection {
        private final String remoteAddr;
        private final String remoteHost;
        private final int remotePort;
        private final String localAddr;
        private final int localPort;

        public AdaptedClientConnection(ClientConnection c) {
            this.remoteAddr = c == null ? null : c.getRemoteAddr();
            this.remoteHost = c == null ? null : c.getRemoteHost();
            this.remotePort = c == null ? 0 : c.getRemotePort();
            this.localAddr = c == null ? null : c.getLocalAddr();
            this.localPort = c == null ? 0 : c.getLocalPort();
        }

        public String getRemoteAddr() {
            return this.remoteAddr;
        }

        public String getRemoteHost() {
            return this.remoteHost;
        }

        public int getRemotePort() {
            return this.remotePort;
        }

        public String getLocalAddr() {
            return this.localAddr;
        }

        public int getLocalPort() {
            return this.localPort;
        }
    }
}

