/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile.validator;

import jakarta.ws.rs.core.Response;
import java.util.List;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.services.validation.Validation;
import org.keycloak.userprofile.UserProfileAttributeValidationContext;
import org.keycloak.validate.SimpleValidator;
import org.keycloak.validate.ValidationContext;
import org.keycloak.validate.ValidationError;
import org.keycloak.validate.ValidatorConfig;

public class DuplicateEmailValidator
implements SimpleValidator {
    public static final String ID = "up-duplicate-email";

    public String getId() {
        return ID;
    }

    public ValidationContext validate(Object input, String inputHint, ValidationContext context, ValidatorConfig config) {
        List values = (List)input;
        if (values == null || values.isEmpty()) {
            return context;
        }
        String value = (String)values.get(0);
        if (Validation.isBlank(value)) {
            return context;
        }
        KeycloakSession session = context.getSession();
        RealmModel realm = session.getContext().getRealm();
        if (!realm.isDuplicateEmailsAllowed()) {
            UserModel userByEmail = session.users().getUserByEmail(realm, value);
            UserModel user = UserProfileAttributeValidationContext.from((ValidationContext)context).getAttributeContext().getUser();
            if (!(userByEmail == null || user != null && userByEmail.getId().equals(user.getId()))) {
                context.addError(new ValidationError(ID, inputHint, "emailExistsMessage").setStatusCode(Response.Status.CONFLICT));
            } else if (realm.isLoginWithEmailAllowed() && (userByEmail = session.users().getUserByUsername(realm, value)) != null && (user == null || !userByEmail.getId().equals(user.getId()))) {
                context.addError(new ValidationError(ID, inputHint, "emailExistsMessage").setStatusCode(Response.Status.CONFLICT));
            }
        }
        return context;
    }
}

