/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.legacy.infinispan;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.metrics.config.MicrometerMeterRegisterConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.jboss.logging.Logger;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.TCP_NIO2;
import org.jgroups.protocols.UDP;
import org.jgroups.util.TLS;
import org.jgroups.util.TLSClientAuth;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class CacheManagerFactory {
    private static final Logger logger = Logger.getLogger(CacheManagerFactory.class);
    private String config;
    private final boolean metricsEnabled;
    private DefaultCacheManager cacheManager;
    private Future<DefaultCacheManager> cacheManagerFuture;
    private ExecutorService executor;
    private boolean initialized;

    public CacheManagerFactory(String config, boolean metricsEnabled) {
        this.config = config;
        this.metricsEnabled = metricsEnabled;
        this.executor = this.createThreadPool();
        this.cacheManagerFuture = this.executor.submit(this::startCacheManager);
    }

    public DefaultCacheManager getOrCreate() {
        if (this.cacheManager == null) {
            if (this.initialized) {
                return null;
            }
            try {
                DefaultCacheManager defaultCacheManager = this.cacheManager = this.cacheManagerFuture.get(this.getStartTimeout().intValue(), TimeUnit.SECONDS);
                return defaultCacheManager;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start caches", e);
            }
            finally {
                this.shutdownThreadPool();
            }
        }
        return this.cacheManager;
    }

    private ExecutorService createThreadPool() {
        return Executors.newSingleThreadExecutor(r -> new Thread(r, "keycloak-cache-init"));
    }

    private DefaultCacheManager startCacheManager() {
        ConfigurationBuilderHolder builder = new ParserRegistry().parse(this.config);
        if (((ConfigurationBuilder)builder.getNamedConfigurationBuilders().get("sessions")).clustering().cacheMode().isClustered()) {
            this.configureTransportStack(builder);
            this.configureRemoteStores(builder);
        }
        if (this.metricsEnabled) {
            builder.getGlobalConfigurationBuilder().addModule(MicrometerMeterRegisterConfigurationBuilder.class);
            ((MicrometerMeterRegisterConfigurationBuilder)builder.getGlobalConfigurationBuilder().module(MicrometerMeterRegisterConfigurationBuilder.class)).meterRegistry((MeterRegistry)Metrics.globalRegistry);
        }
        builder.getGlobalConfigurationBuilder().serialization().marshaller((Marshaller)new JBossUserMarshaller());
        return new DefaultCacheManager(builder, this.isStartEagerly());
    }

    private boolean isStartEagerly() {
        return Boolean.parseBoolean(System.getProperty("kc.cache-ispn-start-eagerly", Boolean.TRUE.toString()));
    }

    private Integer getStartTimeout() {
        return Integer.getInteger("kc.cache-ispn-start-timeout", 120);
    }

    private void shutdownThreadPool() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                        Logger.getLogger(CacheManagerFactory.class).warn((Object)"Cache init thread pool not terminated");
                    }
                }
            }
            catch (Exception cause) {
                this.executor.shutdownNow();
            }
            finally {
                this.executor = null;
                this.cacheManagerFuture = null;
                this.config = null;
                this.initialized = true;
            }
        }
    }

    private void configureTransportStack(ConfigurationBuilderHolder builder) {
        String transportStack = Configuration.getRawValue((String)"kc.cache-stack");
        TransportConfigurationBuilder transportConfig = builder.getGlobalConfigurationBuilder().transport();
        if (transportStack != null && !transportStack.isBlank()) {
            transportConfig.defaultTransport().stack(transportStack);
        }
        if (CacheManagerFactory.booleanProperty("cache-embedded-mtls-enabled")) {
            this.validateTlsAvailable(transportConfig.build());
            TLS tls = new TLS().enabled(true).setKeystorePath(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-key-store-file")).setKeystorePassword(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-key-store-password")).setKeystoreType("pkcs12").setTruststorePath(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-trust-store-file")).setTruststorePassword(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-trust-store-password")).setTruststoreType("pkcs12").setClientAuth(TLSClientAuth.NEED).setProtocols(new String[]{"TLSv1.3"});
            transportConfig.addProperty("socketFactory", (Object)tls.createSocketFactory());
            Logger.getLogger(CacheManagerFactory.class).info((Object)"MTLS enabled for communications for embedded caches");
        }
    }

    private void validateTlsAvailable(GlobalConfiguration config) {
        String stackName = config.transport().stack();
        if (stackName == null) {
            return;
        }
        for (ProtocolConfiguration protocol : config.transport().jgroups().configurator(stackName).getProtocolStack()) {
            String name = protocol.getProtocolName();
            if (!name.equals(UDP.class.getSimpleName()) && !name.equals(UDP.class.getName()) && !name.equals(TCP_NIO2.class.getSimpleName()) && !name.equals(TCP_NIO2.class.getName())) continue;
            throw new RuntimeException("Cache TLS is not available with protocol " + name);
        }
    }

    private void configureRemoteStores(ConfigurationBuilderHolder builder) {
        if (Configuration.getOptionalKcValue((String)"cache-remote-host").isPresent() || Configuration.getOptionalKcValue((String)"cache-remote-username").isPresent() || Configuration.getOptionalKcValue((String)"cache-remote-password").isPresent()) {
            SSLContext sslContext;
            String cacheRemoteHost = CacheManagerFactory.requiredStringProperty("cache-remote-host");
            Integer cacheRemotePort = Configuration.getOptionalKcValue((String)"cache-remote-port").map(Integer::parseInt).orElse(11222);
            String cacheRemoteUsername = CacheManagerFactory.requiredStringProperty("cache-remote-username");
            String cacheRemotePassword = CacheManagerFactory.requiredStringProperty("cache-remote-password");
            try {
                sslContext = SSLContext.getInstance("TLS");
                sslContext.init(null, null, null);
            }
            catch (KeyManagementException | NoSuchAlgorithmException e) {
                throw new RuntimeException(e);
            }
            InfinispanConnectionProvider.DISTRIBUTED_REPLICATED_CACHE_NAMES.forEach(cacheName -> {
                PersistenceConfigurationBuilder persistenceCB = ((ConfigurationBuilder)builder.getNamedConfigurationBuilders().get(cacheName)).persistence();
                if (!persistenceCB.stores().isEmpty()) {
                    throw new RuntimeException(String.format("Remote store for cache '%s' is already configured via CLI parameters. It should not be present in the XML file.", cacheName));
                }
                ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)persistenceCB.addStore(RemoteStoreConfigurationBuilder.class)).rawValues(true).shared(true)).segmented(false)).remoteCacheName(cacheName).connectionPool().maxActive(16).exhaustedAction(ExhaustedAction.CREATE_NEW).remoteSecurity().ssl().enable().sslContext(sslContext).sniHostName(cacheRemoteHost).authentication().enable().username(cacheRemoteUsername).password(cacheRemotePassword).realm("default").saslMechanism("SCRAM-SHA-512").addServer().host(cacheRemoteHost).port(cacheRemotePort.intValue());
            });
        }
    }

    private static boolean booleanProperty(String propertyName) {
        return Configuration.getOptionalKcValue((String)propertyName).map(Boolean::parseBoolean).orElse(Boolean.FALSE);
    }

    private static String requiredStringProperty(String propertyName) {
        return (String)Configuration.getOptionalKcValue((String)propertyName).orElseThrow(() -> new RuntimeException("Property " + propertyName + " required but not specified"));
    }

    public CacheManagerFactory() {
    }
}

