/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.property.access.internal;

import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;
import org.hibernate.HibernateException;
import org.hibernate.boot.registry.selector.spi.StrategySelector;
import org.hibernate.engine.internal.ManagedTypeHelper;
import org.hibernate.internal.util.NullnessUtil;
import org.hibernate.internal.util.StringHelper;
import org.hibernate.metamodel.RepresentationMode;
import org.hibernate.property.access.internal.PropertyAccessStrategyEnhancedImpl;
import org.hibernate.property.access.spi.BuiltInPropertyAccessStrategies;
import org.hibernate.property.access.spi.PropertyAccessStrategy;
import org.hibernate.property.access.spi.PropertyAccessStrategyResolver;
import org.hibernate.service.ServiceRegistry;

public class PropertyAccessStrategyResolverStandardImpl
implements PropertyAccessStrategyResolver {
    private final @UnknownKeyFor @NonNull @Initialized ServiceRegistry serviceRegistry;
    private @UnknownKeyFor @NonNull @Initialized StrategySelector strategySelectorService;

    public PropertyAccessStrategyResolverStandardImpl(@UnknownKeyFor @NonNull @Initialized ServiceRegistry serviceRegistry) {
        this.serviceRegistry = serviceRegistry;
    }

    @Override
    public @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy resolvePropertyAccessStrategy(/*
     * Issues handling annotations - annotations may be inaccurate
     */
    @UnknownKeyFor @NonNull @Initialized Class<@UnknownKeyFor @UnknownKeyFor @Nullable @Initialized @NonNull @Initialized ?> containerClass, @UnknownKeyFor @NonNull @Initialized String explicitAccessStrategyName, @UnknownKeyFor @NonNull @Initialized RepresentationMode representationMode) {
        if ((BuiltInPropertyAccessStrategies.BASIC.getExternalName().equals(explicitAccessStrategyName) || BuiltInPropertyAccessStrategies.FIELD.getExternalName().equals(explicitAccessStrategyName) || BuiltInPropertyAccessStrategies.MIXED.getExternalName().equals(explicitAccessStrategyName)) && ManagedTypeHelper.isManagedType(containerClass)) {
            if (BuiltInPropertyAccessStrategies.FIELD.getExternalName().equals(explicitAccessStrategyName)) {
                return PropertyAccessStrategyEnhancedImpl.FIELD;
            }
            return PropertyAccessStrategyEnhancedImpl.STANDARD;
        }
        if (StringHelper.isNotEmpty(explicitAccessStrategyName)) {
            return this.resolveExplicitlyNamedPropertyAccessStrategy(explicitAccessStrategyName);
        }
        if (representationMode == RepresentationMode.MAP) {
            return BuiltInPropertyAccessStrategies.MAP.getStrategy();
        }
        return BuiltInPropertyAccessStrategies.BASIC.getStrategy();
    }

    protected @UnknownKeyFor @NonNull @Initialized PropertyAccessStrategy resolveExplicitlyNamedPropertyAccessStrategy(@UnknownKeyFor @NonNull @Initialized String explicitAccessStrategyName) {
        BuiltInPropertyAccessStrategies builtInStrategyEnum = BuiltInPropertyAccessStrategies.interpret(explicitAccessStrategyName);
        if (builtInStrategyEnum != null) {
            return builtInStrategyEnum.getStrategy();
        }
        return this.strategySelectorService().resolveStrategy(PropertyAccessStrategy.class, explicitAccessStrategyName);
    }

    protected @UnknownKeyFor @NonNull @Initialized StrategySelector strategySelectorService() {
        if (this.strategySelectorService == null) {
            if (this.serviceRegistry == null) {
                throw new HibernateException("ServiceRegistry not yet injected; PropertyAccessStrategyResolver not ready for use.");
            }
            this.strategySelectorService = NullnessUtil.castNonNull(this.serviceRegistry.getService(StrategySelector.class));
        }
        return this.strategySelectorService;
    }
}

