/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.sql.results.graph.entity.internal;

import org.hibernate.cache.spi.access.EntityDataAccess;
import org.hibernate.metamodel.internal.StandardEmbeddableInstantiator;
import org.hibernate.metamodel.mapping.EmbeddableValuedModelPart;
import org.hibernate.metamodel.mapping.EntityValuedModelPart;
import org.hibernate.metamodel.mapping.internal.ToOneAttributeMapping;
import org.hibernate.persister.entity.EntityPersister;
import org.hibernate.spi.NavigablePath;
import org.hibernate.sql.results.graph.AbstractFetchParentAccess;
import org.hibernate.sql.results.graph.AssemblerCreationState;
import org.hibernate.sql.results.graph.DomainResult;
import org.hibernate.sql.results.graph.FetchParentAccess;
import org.hibernate.sql.results.graph.embeddable.EmbeddableInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntityInsideEmbeddableSelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.BatchInitializeEntitySelectFetchInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchByUniqueKeyInitializer;
import org.hibernate.sql.results.graph.entity.internal.EntitySelectFetchInitializer;

public class EntitySelectFetchInitializerBuilder {
    public static AbstractFetchParentAccess createInitializer(FetchParentAccess parentAccess, ToOneAttributeMapping fetchedAttribute, EntityPersister entityPersister, DomainResult<?> keyResult, NavigablePath navigablePath, boolean selectByUniqueKey, AssemblerCreationState creationState) {
        if (selectByUniqueKey) {
            return new EntitySelectFetchByUniqueKeyInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
        }
        if (parentAccess.findFirstEntityInitializer() == null) {
            return new EntitySelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
        }
        BatchMode batchMode = EntitySelectFetchInitializerBuilder.determineBatchMode(entityPersister, parentAccess, creationState);
        switch (batchMode) {
            case NONE: {
                return new EntitySelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
            }
            case BATCH_LOAD: {
                if (parentAccess.isEmbeddableInitializer()) {
                    return new BatchEntityInsideEmbeddableSelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
                }
                return new BatchEntitySelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
            }
            case BATCH_INITIALIZE: {
                return new BatchInitializeEntitySelectFetchInitializer(parentAccess, fetchedAttribute, navigablePath, entityPersister, keyResult.createResultAssembler(parentAccess, creationState));
            }
        }
        throw new IllegalStateException("Should be unreachable");
    }

    private static BatchMode determineBatchMode(EntityPersister entityPersister, FetchParentAccess parentAccess, AssemblerCreationState creationState) {
        if (creationState.isScrollResult() || !creationState.getExecutionContext().getSession().getLoadQueryInfluencers().effectivelyBatchLoadable(entityPersister)) {
            return BatchMode.NONE;
        }
        if (creationState.isDynamicInstantiation()) {
            if (EntitySelectFetchInitializerBuilder.canBatchInitializeBeUsed(entityPersister)) {
                return BatchMode.BATCH_INITIALIZE;
            }
            return BatchMode.NONE;
        }
        while (parentAccess.isEmbeddableInitializer()) {
            EmbeddableInitializer embeddableInitializer = parentAccess.asEmbeddableInitializer();
            EmbeddableValuedModelPart initializedPart = embeddableInitializer.getInitializedPart();
            if (initializedPart.isEntityIdentifierMapping() || initializedPart.isVirtual() || !(initializedPart.getMappedType().getRepresentationStrategy().getInstantiator() instanceof StandardEmbeddableInstantiator)) {
                return entityPersister.hasSubclasses() ? BatchMode.NONE : BatchMode.BATCH_INITIALIZE;
            }
            if ((parentAccess = parentAccess.getFetchParentAccess()) != null) continue;
            break;
        }
        if (parentAccess != null) {
            assert (parentAccess.getInitializedPart() instanceof EntityValuedModelPart);
            EntityPersister parentPersister = parentAccess.asEntityInitializer().getEntityDescriptor();
            EntityDataAccess cacheAccess = parentPersister.getCacheAccessStrategy();
            if (cacheAccess != null) {
                if (EntitySelectFetchInitializerBuilder.canBatchInitializeBeUsed(entityPersister)) {
                    return BatchMode.BATCH_INITIALIZE;
                }
                return BatchMode.NONE;
            }
        }
        return BatchMode.BATCH_LOAD;
    }

    private static boolean canBatchInitializeBeUsed(EntityPersister entityPersister) {
        return entityPersister.getRepresentationStrategy().getProxyFactory() != null;
    }

    static enum BatchMode {
        NONE,
        BATCH_LOAD,
        BATCH_INITIALIZE;

    }
}

