/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.ForbiddenException;
import jakarta.ws.rs.NotFoundException;
import jakarta.ws.rs.Path;
import jakarta.ws.rs.PathParam;
import org.keycloak.admin.ui.rest.UserResource;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.light.LightweightUserAdapter;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class UsersResource {
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;

    public UsersResource(KeycloakSession session, AdminPermissionEvaluator auth) {
        this.session = session;
        this.auth = auth;
    }

    @Path(value="{id}")
    public UserResource getUser(@PathParam(value="id") String id) {
        RealmModel realm = this.session.getContext().getRealm();
        UserModel user = null;
        if (LightweightUserAdapter.isLightweightUser((String)id)) {
            UserSessionModel userSession = this.session.sessions().getUserSession(realm, LightweightUserAdapter.getLightweightUserId((String)id));
            if (userSession != null) {
                user = userSession.getUser();
            }
        } else {
            user = this.session.users().getUserById(realm, id);
        }
        if (user == null) {
            if (this.auth.users().canQuery()) {
                throw new NotFoundException("User not found");
            }
            throw new ForbiddenException();
        }
        return new UserResource(this.session, this.auth, user);
    }
}

