/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.loader.ast.internal;

import java.lang.reflect.Array;
import org.hibernate.collection.spi.PersistentCollection;
import org.hibernate.engine.spi.CollectionEntry;
import org.hibernate.engine.spi.CollectionKey;
import org.hibernate.engine.spi.LoadQueryInfluencers;
import org.hibernate.engine.spi.PersistenceContext;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.hibernate.engine.spi.SharedSessionContractImplementor;
import org.hibernate.loader.ast.internal.CollectionLoaderSingleKey;
import org.hibernate.loader.ast.internal.MultiKeyLoadHelper;
import org.hibernate.loader.ast.internal.MultiKeyLoadLogging;
import org.hibernate.loader.ast.spi.CollectionBatchLoader;
import org.hibernate.metamodel.mapping.NonAggregatedIdentifierMapping;
import org.hibernate.metamodel.mapping.PluralAttributeMapping;
import org.hibernate.metamodel.mapping.ValuedModelPart;
import org.hibernate.metamodel.mapping.internal.IdClassEmbeddable;
import org.hibernate.sql.results.internal.ResultsHelper;

public abstract class AbstractCollectionBatchLoader
implements CollectionBatchLoader {
    private final int domainBatchSize;
    private final PluralAttributeMapping attributeMapping;
    private final LoadQueryInfluencers influencers;
    private final SessionFactoryImplementor sessionFactory;
    private final int keyJdbcCount;
    final CollectionLoaderSingleKey singleKeyLoader;

    public AbstractCollectionBatchLoader(int domainBatchSize, LoadQueryInfluencers influencers, PluralAttributeMapping attributeMapping, SessionFactoryImplementor sessionFactory) {
        this.domainBatchSize = domainBatchSize;
        this.attributeMapping = attributeMapping;
        this.keyJdbcCount = attributeMapping.getJdbcTypeCount();
        this.sessionFactory = sessionFactory;
        this.influencers = influencers;
        this.singleKeyLoader = new CollectionLoaderSingleKey(this.getLoadable(), this.getInfluencers(), this.getSessionFactory());
    }

    @Override
    public int getDomainBatchSize() {
        return this.domainBatchSize;
    }

    @Override
    public PluralAttributeMapping getLoadable() {
        return this.attributeMapping;
    }

    public LoadQueryInfluencers getInfluencers() {
        return this.influencers;
    }

    public SessionFactoryImplementor getSessionFactory() {
        return this.sessionFactory;
    }

    public int getKeyJdbcCount() {
        return this.keyJdbcCount;
    }

    abstract void initializeKeys(Object var1, Object[] var2, SharedSessionContractImplementor var3);

    @Override
    public PersistentCollection<?> load(Object key, SharedSessionContractImplementor session) {
        Object[] keys;
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Batch fetching collection: %s.%s", (Object)this.getLoadable().getNavigableRole().getFullPath(), key);
        }
        if (MultiKeyLoadHelper.hasSingleId(keys = this.resolveKeysToInitialize(key, session))) {
            return this.singleKeyLoader.load(key, session);
        }
        this.initializeKeys(key, keys, session);
        this.finishInitializingKeys(keys, session);
        CollectionKey collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), key);
        return session.getPersistenceContext().getCollection(collectionKey);
    }

    abstract void finishInitializingKeys(Object[] var1, SharedSessionContractImplementor var2);

    protected void finishInitializingKey(Object key, SharedSessionContractImplementor session) {
        CollectionKey collectionKey;
        PersistenceContext persistenceContext;
        PersistentCollection<?> collection;
        if (key == null) {
            return;
        }
        if (MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.isDebugEnabled()) {
            MultiKeyLoadLogging.MULTI_KEY_LOAD_LOGGER.debugf("Finishing initializing batch-fetched collection: %s.%s", (Object)this.attributeMapping.getNavigableRole().getFullPath(), key);
        }
        if (!(collection = (persistenceContext = session.getPersistenceContext()).getCollection(collectionKey = new CollectionKey(this.getLoadable().getCollectionDescriptor(), key))).wasInitialized()) {
            CollectionEntry entry = persistenceContext.getCollectionEntry(collection);
            collection.initializeEmptyCollection(entry.getLoadedPersister());
            ResultsHelper.finalizeCollectionLoading(persistenceContext, entry.getLoadedPersister(), collection, key, true);
        }
    }

    Object[] resolveKeysToInitialize(Object keyBeingLoaded, SharedSessionContractImplementor session) {
        int length = this.getDomainBatchSize();
        Object[] keysToInitialize = (Object[])Array.newInstance(this.getKeyType(this.getLoadable().getKeyDescriptor().getKeyPart()), length);
        session.getPersistenceContextInternal().getBatchFetchQueue().collectBatchLoadableCollectionKeys(length, (index, key) -> {
            keysToInitialize[index] = key;
        }, keyBeingLoaded, this.getLoadable());
        return MultiKeyLoadHelper.trimIdBatch(length, keysToInitialize);
    }

    protected Class<?> getKeyType(ValuedModelPart keyPart) {
        IdClassEmbeddable idClassEmbeddable;
        if (keyPart instanceof NonAggregatedIdentifierMapping && (idClassEmbeddable = ((NonAggregatedIdentifierMapping)keyPart).getIdClassEmbeddable()) != null) {
            return idClassEmbeddable.getMappedJavaType().getJavaTypeClass();
        }
        return keyPart.getJavaType().getJavaTypeClass();
    }
}

