/*
 * Decompiled with CFR 0.152.
 */
package biz.paluch.logging;

import biz.paluch.logging.RuntimeContainerProperties;
import biz.paluch.logging.gelf.intern.ErrorReporter;
import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.util.Enumeration;

public class RuntimeContainer {
    public static String HOSTNAME;
    public static String FQDN_HOSTNAME;
    public static String ADDRESS;
    public static final long FIRST_ACCESS;
    private static boolean initialized;

    private RuntimeContainer() {
    }

    public static void initialize(ErrorReporter errorReporter) {
        if (!initialized) {
            RuntimeContainer.lookupHostname(errorReporter);
            initialized = true;
        }
    }

    public static void lookupHostname(ErrorReporter errorReporter) {
        String myHostName = RuntimeContainerProperties.getProperty("logstash-gelf.hostname", "unknown");
        String myFQDNHostName = RuntimeContainerProperties.getProperty("logstash-gelf.fqdn.hostname", "unknown");
        String myAddress = "";
        if (!Boolean.parseBoolean(RuntimeContainerProperties.getProperty("logstash-gelf.skipHostnameResolution", "false"))) {
            try {
                String resolutionOrder = RuntimeContainerProperties.getProperty("logstash-gelf.resolutionOrder", "network,localhost");
                InetAddress inetAddress = null;
                if (resolutionOrder.equals("network,localhost")) {
                    inetAddress = RuntimeContainer.getInetAddressWithHostname();
                }
                if (resolutionOrder.equals("localhost,network")) {
                    inetAddress = RuntimeContainer.isQualified(InetAddress.getLocalHost()) ? InetAddress.getLocalHost() : RuntimeContainer.getInetAddressWithHostname();
                }
                if (inetAddress == null) {
                    inetAddress = InetAddress.getLocalHost();
                }
                myHostName = RuntimeContainer.getHostname(inetAddress, false);
                myFQDNHostName = RuntimeContainer.getHostname(inetAddress, true);
                myAddress = inetAddress.getHostAddress();
            }
            catch (IOException e) {
                errorReporter.reportError("Cannot resolve hostname", e);
            }
        }
        FQDN_HOSTNAME = myFQDNHostName;
        HOSTNAME = myHostName;
        ADDRESS = myAddress;
    }

    private static String getHostname(InetAddress inetAddress, boolean fqdn) throws IOException {
        String hostname = inetAddress.getHostName();
        if (hostname.indexOf(46) != -1 && !fqdn) {
            hostname = hostname.substring(0, hostname.indexOf(46));
        }
        return hostname;
    }

    private static InetAddress getInetAddressWithHostname() throws SocketException {
        Enumeration<NetworkInterface> netInterfaces = NetworkInterface.getNetworkInterfaces();
        while (netInterfaces.hasMoreElements()) {
            NetworkInterface ni = netInterfaces.nextElement();
            Enumeration<InetAddress> ias = ni.getInetAddresses();
            while (ias.hasMoreElements()) {
                InetAddress inetAddress = ias.nextElement();
                if (!RuntimeContainer.isQualified(inetAddress)) continue;
                return inetAddress;
            }
        }
        return null;
    }

    private static boolean isQualified(InetAddress inetAddress) {
        return !inetAddress.isLoopbackAddress() && !inetAddress.getHostAddress().equals(inetAddress.getCanonicalHostName());
    }

    public static void main(String[] args) {
        System.out.println("Host-Resolution: " + FQDN_HOSTNAME + "/" + HOSTNAME);
    }

    static {
        FIRST_ACCESS = System.currentTimeMillis();
    }
}

