/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.configuration.cache;

import java.util.List;
import org.infinispan.commons.configuration.attributes.AttributeDefinition;
import org.infinispan.commons.configuration.attributes.AttributeSet;
import org.infinispan.commons.configuration.attributes.ConfigurationElement;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.configuration.parsing.Attribute;
import org.infinispan.configuration.parsing.Element;

public class PersistenceConfiguration
extends ConfigurationElement<PersistenceConfiguration> {
    public static final AttributeDefinition<Boolean> PASSIVATION = AttributeDefinition.builder((Enum)Attribute.PASSIVATION, (Object)false).immutable().build();
    public static final AttributeDefinition<Integer> AVAILABILITY_INTERVAL = AttributeDefinition.builder((Enum)Attribute.AVAILABILITY_INTERVAL, (Object)30000).immutable().build();
    public static final AttributeDefinition<Integer> CONNECTION_ATTEMPTS = AttributeDefinition.builder((Enum)Attribute.CONNECTION_ATTEMPTS, (Object)10).build();
    @Deprecated(forRemoval=true, since="15.0")
    public static final AttributeDefinition<Integer> CONNECTION_INTERVAL = AttributeDefinition.builder((Enum)Attribute.CONNECTION_INTERVAL, (Object)50).immutable().deprecated(15, 0).build();
    private final List<StoreConfiguration> stores;

    static AttributeSet attributeDefinitionSet() {
        return new AttributeSet(PersistenceConfiguration.class, new AttributeDefinition[]{PASSIVATION, AVAILABILITY_INTERVAL, CONNECTION_ATTEMPTS, CONNECTION_INTERVAL});
    }

    PersistenceConfiguration(AttributeSet attributes, List<StoreConfiguration> stores) {
        super((Enum)Element.PERSISTENCE, attributes, PersistenceConfiguration.asChildren(stores));
        this.stores = stores;
    }

    private static ConfigurationElement<?>[] asChildren(List<StoreConfiguration> stores) {
        return (ConfigurationElement[])stores.stream().filter(store -> store instanceof ConfigurationElement).toArray(ConfigurationElement[]::new);
    }

    public boolean passivation() {
        return (Boolean)this.attributes.attribute(PASSIVATION).get();
    }

    public int availabilityInterval() {
        return (Integer)this.attributes.attribute(AVAILABILITY_INTERVAL).get();
    }

    public int connectionAttempts() {
        return (Integer)this.attributes.attribute(CONNECTION_ATTEMPTS).get();
    }

    @Deprecated(forRemoval=true, since="15.0")
    public int connectionInterval() {
        return -1;
    }

    public List<StoreConfiguration> stores() {
        return this.stores;
    }

    @Deprecated(forRemoval=true, since="14.0")
    public Boolean fetchPersistentState() {
        return false;
    }

    public Boolean preload() {
        for (StoreConfiguration c : this.stores) {
            if (!c.preload()) continue;
            return true;
        }
        return false;
    }

    public boolean usingStores() {
        return !this.stores.isEmpty();
    }

    public boolean usingAsyncStore() {
        for (StoreConfiguration c : this.stores) {
            if (!c.async().enabled()) continue;
            return true;
        }
        return false;
    }

    public boolean usingSegmentedStore() {
        for (StoreConfiguration c : this.stores) {
            if (!c.segmented()) continue;
            return true;
        }
        return false;
    }
}

