/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.factories;

import java.util.List;
import org.infinispan.commons.CacheConfigurationException;
import org.infinispan.commons.CacheException;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.Configurations;
import org.infinispan.configuration.cache.StoreConfiguration;
import org.infinispan.factories.AbstractNamedCacheComponentFactory;
import org.infinispan.factories.AutoInstantiableFactory;
import org.infinispan.factories.annotations.DefaultFactoryFor;
import org.infinispan.factories.impl.ComponentRef;
import org.infinispan.interceptors.AsyncInterceptor;
import org.infinispan.interceptors.AsyncInterceptorChain;
import org.infinispan.interceptors.EmptyAsyncInterceptorChain;
import org.infinispan.interceptors.distribution.L1LastChanceInterceptor;
import org.infinispan.interceptors.distribution.L1NonTxInterceptor;
import org.infinispan.interceptors.distribution.L1TxInterceptor;
import org.infinispan.interceptors.distribution.NonTxDistributionInterceptor;
import org.infinispan.interceptors.distribution.TriangleDistributionInterceptor;
import org.infinispan.interceptors.distribution.TxDistributionInterceptor;
import org.infinispan.interceptors.distribution.VersionedDistributionInterceptor;
import org.infinispan.interceptors.impl.AsyncInterceptorChainImpl;
import org.infinispan.interceptors.impl.BatchingInterceptor;
import org.infinispan.interceptors.impl.CacheLoaderInterceptor;
import org.infinispan.interceptors.impl.CacheMgmtInterceptor;
import org.infinispan.interceptors.impl.CacheWriterInterceptor;
import org.infinispan.interceptors.impl.CallInterceptor;
import org.infinispan.interceptors.impl.ClusteredCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.DistCacheWriterInterceptor;
import org.infinispan.interceptors.impl.EntryWrappingInterceptor;
import org.infinispan.interceptors.impl.InvalidationInterceptor;
import org.infinispan.interceptors.impl.InvocationContextInterceptor;
import org.infinispan.interceptors.impl.IsMarshallableInterceptor;
import org.infinispan.interceptors.impl.NonTxIracLocalSiteInterceptor;
import org.infinispan.interceptors.impl.NonTxIracRemoteSiteInterceptor;
import org.infinispan.interceptors.impl.NotificationInterceptor;
import org.infinispan.interceptors.impl.OptimisticTxIracLocalSiteInterceptor;
import org.infinispan.interceptors.impl.PassivationCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.PassivationClusteredCacheLoaderInterceptor;
import org.infinispan.interceptors.impl.PassivationWriterInterceptor;
import org.infinispan.interceptors.impl.PessimisticTxIracLocalInterceptor;
import org.infinispan.interceptors.impl.TransactionalExceptionEvictionInterceptor;
import org.infinispan.interceptors.impl.TransactionalStoreInterceptor;
import org.infinispan.interceptors.impl.TxInterceptor;
import org.infinispan.interceptors.impl.VersionInterceptor;
import org.infinispan.interceptors.impl.VersionedEntryWrappingInterceptor;
import org.infinispan.interceptors.locking.NonTransactionalLockingInterceptor;
import org.infinispan.interceptors.locking.OptimisticLockingInterceptor;
import org.infinispan.interceptors.locking.PessimisticLockingInterceptor;
import org.infinispan.interceptors.xsite.NonTransactionalBackupInterceptor;
import org.infinispan.interceptors.xsite.OptimisticBackupInterceptor;
import org.infinispan.interceptors.xsite.PessimisticBackupInterceptor;
import org.infinispan.partitionhandling.PartitionHandling;
import org.infinispan.partitionhandling.impl.PartitionHandlingInterceptor;
import org.infinispan.statetransfer.StateTransferInterceptor;
import org.infinispan.statetransfer.TransactionSynchronizerInterceptor;
import org.infinispan.transaction.LockingMode;
import org.infinispan.transaction.TransactionMode;
import org.infinispan.util.logging.Log;
import org.infinispan.util.logging.LogFactory;

@DefaultFactoryFor(classes={AsyncInterceptorChain.class})
public class InterceptorChainFactory
extends AbstractNamedCacheComponentFactory
implements AutoInstantiableFactory {
    private static final Log log = LogFactory.getLog(InterceptorChainFactory.class);

    private AsyncInterceptor createInterceptor(AsyncInterceptor interceptor, Class<? extends AsyncInterceptor> interceptorType) {
        ComponentRef<? extends AsyncInterceptor> chainedInterceptor = this.basicComponentRegistry.getComponent(interceptorType);
        if (chainedInterceptor != null) {
            return chainedInterceptor.wired();
        }
        this.register(interceptorType, interceptor);
        return interceptor;
    }

    private void register(Class<? extends AsyncInterceptor> clazz, AsyncInterceptor chainedInterceptor) {
        try {
            this.basicComponentRegistry.registerComponent(clazz.getName(), chainedInterceptor, true);
            this.basicComponentRegistry.addDynamicDependency(AsyncInterceptorChain.class.getName(), clazz.getName());
        }
        catch (RuntimeException e) {
            log.unableToCreateInterceptor(clazz, e);
            throw e;
        }
    }

    private AsyncInterceptorChain buildInterceptorChain() {
        TransactionMode transactionMode = this.configuration.transaction().transactionMode();
        boolean needsVersionAwareComponents = Configurations.isTxVersioned(this.configuration);
        AsyncInterceptorChainImpl interceptorChain = new AsyncInterceptorChainImpl();
        boolean invocationBatching = this.configuration.invocationBatching().enabled();
        CacheMode cacheMode = this.configuration.clustering().cacheMode();
        if (invocationBatching) {
            interceptorChain.appendInterceptor(this.createInterceptor(new BatchingInterceptor(), BatchingInterceptor.class), false);
        }
        interceptorChain.appendInterceptor(this.createInterceptor(new InvocationContextInterceptor(), InvocationContextInterceptor.class), false);
        if (!this.configuration.transaction().transactionMode().isTransactional()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new VersionInterceptor(), VersionInterceptor.class), false);
        }
        if (this.hasAsyncStore()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new IsMarshallableInterceptor(), IsMarshallableInterceptor.class), false);
        }
        interceptorChain.appendInterceptor(this.createInterceptor(new CacheMgmtInterceptor(), CacheMgmtInterceptor.class), false);
        if (cacheMode.needsStateTransfer() || cacheMode.isInvalidation() && transactionMode.isTransactional()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new StateTransferInterceptor(), StateTransferInterceptor.class), false);
        }
        if (cacheMode.needsStateTransfer()) {
            if (transactionMode.isTransactional()) {
                interceptorChain.appendInterceptor(this.createInterceptor(new TransactionSynchronizerInterceptor(), TransactionSynchronizerInterceptor.class), false);
            }
            if (this.configuration.clustering().partitionHandling().whenSplit() != PartitionHandling.ALLOW_READ_WRITES) {
                interceptorChain.appendInterceptor(this.createInterceptor(new PartitionHandlingInterceptor(), PartitionHandlingInterceptor.class), false);
            }
        }
        if (transactionMode.isTransactional()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TxInterceptor(), TxInterceptor.class), false);
        }
        if (transactionMode.isTransactional()) {
            if (this.configuration.transaction().lockingMode() == LockingMode.PESSIMISTIC) {
                interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticLockingInterceptor(), PessimisticLockingInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticLockingInterceptor(), OptimisticLockingInterceptor.class), false);
            }
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(new NonTransactionalLockingInterceptor(), NonTransactionalLockingInterceptor.class), false);
        }
        if (transactionMode.isTransactional() && this.configuration.transaction().notifications()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new NotificationInterceptor(), NotificationInterceptor.class), false);
        }
        if (this.configuration.sites().hasBackups()) {
            if (transactionMode == TransactionMode.TRANSACTIONAL) {
                if (this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticBackupInterceptor(), OptimisticBackupInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticBackupInterceptor(), PessimisticBackupInterceptor.class), false);
                }
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTransactionalBackupInterceptor(), NonTransactionalBackupInterceptor.class), false);
            }
        }
        if (this.configuration.clustering().l1().enabled()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new L1LastChanceInterceptor(), L1LastChanceInterceptor.class), false);
        }
        if (needsVersionAwareComponents) {
            interceptorChain.appendInterceptor(this.createInterceptor(new VersionedEntryWrappingInterceptor(), VersionedEntryWrappingInterceptor.class), false);
        } else {
            interceptorChain.appendInterceptor(this.createInterceptor(new EntryWrappingInterceptor(), EntryWrappingInterceptor.class), false);
        }
        if (transactionMode.isTransactional() && this.configuration.memory().evictionStrategy().isExceptionBased()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new TransactionalExceptionEvictionInterceptor(), TransactionalExceptionEvictionInterceptor.class), false);
        }
        if (this.configuration.persistence().usingStores()) {
            this.addPersistenceInterceptors(interceptorChain, this.configuration, this.configuration.persistence().stores());
        }
        if (this.configuration.clustering().l1().enabled()) {
            if (transactionMode.isTransactional()) {
                interceptorChain.appendInterceptor(this.createInterceptor(new L1TxInterceptor(), L1TxInterceptor.class), false);
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new L1NonTxInterceptor(), L1NonTxInterceptor.class), false);
            }
        }
        if (this.configuration.sites().hasAsyncEnabledBackups() && cacheMode.isClustered()) {
            if (transactionMode == TransactionMode.TRANSACTIONAL) {
                if (this.configuration.transaction().lockingMode() == LockingMode.OPTIMISTIC) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new OptimisticTxIracLocalSiteInterceptor(), OptimisticTxIracLocalSiteInterceptor.class), false);
                } else {
                    interceptorChain.appendInterceptor(this.createInterceptor(new PessimisticTxIracLocalInterceptor(), PessimisticTxIracLocalInterceptor.class), false);
                }
            } else {
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTxIracLocalSiteInterceptor(), NonTxIracLocalSiteInterceptor.class), false);
            }
        }
        switch (cacheMode) {
            case INVALIDATION_SYNC: 
            case INVALIDATION_ASYNC: {
                interceptorChain.appendInterceptor(this.createInterceptor(new InvalidationInterceptor(), InvalidationInterceptor.class), false);
                break;
            }
            case DIST_SYNC: 
            case REPL_SYNC: {
                if (needsVersionAwareComponents) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new VersionedDistributionInterceptor(), VersionedDistributionInterceptor.class), false);
                    break;
                }
            }
            case DIST_ASYNC: 
            case REPL_ASYNC: {
                if (transactionMode.isTransactional()) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new TxDistributionInterceptor(), TxDistributionInterceptor.class), false);
                    break;
                }
                if (cacheMode.isDistributed() && Configurations.isEmbeddedMode(this.globalConfiguration)) {
                    interceptorChain.appendInterceptor(this.createInterceptor(new TriangleDistributionInterceptor(), TriangleDistributionInterceptor.class), false);
                    break;
                }
                interceptorChain.appendInterceptor(this.createInterceptor(new NonTxDistributionInterceptor(), NonTxDistributionInterceptor.class), false);
                break;
            }
        }
        if (cacheMode.isClustered()) {
            interceptorChain.appendInterceptor(this.createInterceptor(new NonTxIracRemoteSiteInterceptor(needsVersionAwareComponents), NonTxIracRemoteSiteInterceptor.class), false);
        }
        AsyncInterceptor callInterceptor = this.createInterceptor(new CallInterceptor(), CallInterceptor.class);
        interceptorChain.appendInterceptor(callInterceptor, false);
        log.trace("Finished building default interceptor chain.");
        return interceptorChain;
    }

    private Class<? extends AsyncInterceptor> addInterceptor(AsyncInterceptorChain interceptorChain, AsyncInterceptor interceptor, Class<? extends AsyncInterceptor> interceptorClass, Class<? extends AsyncInterceptor> after) {
        if (interceptorChain.containsInterceptorType(interceptorClass, true)) {
            return after;
        }
        AsyncInterceptor newInterceptor = this.createInterceptor(interceptor, interceptorClass);
        boolean added = interceptorChain.addInterceptorAfter(newInterceptor, after);
        return added ? newInterceptor.getClass() : after;
    }

    public void addPersistenceInterceptors(AsyncInterceptorChain interceptorChain, Configuration cacheConfiguration, List<StoreConfiguration> stores) {
        TransactionMode transactionMode = cacheConfiguration.transaction().transactionMode();
        CacheMode cacheMode = cacheConfiguration.clustering().cacheMode();
        EntryWrappingInterceptor ewi = interceptorChain.findInterceptorExtending(EntryWrappingInterceptor.class);
        if (ewi == null) {
            throw new CacheException("Cannot find instance of EntryWrappingInterceptor in the interceptor chain");
        }
        Class<Object> lastAdded = ewi.getClass();
        if (cacheConfiguration.persistence().passivation()) {
            lastAdded = cacheMode.isClustered() ? this.addInterceptor(interceptorChain, new PassivationClusteredCacheLoaderInterceptor(), CacheLoaderInterceptor.class, lastAdded) : this.addInterceptor(interceptorChain, new PassivationCacheLoaderInterceptor(), CacheLoaderInterceptor.class, lastAdded);
            this.addInterceptor(interceptorChain, new PassivationWriterInterceptor(), PassivationWriterInterceptor.class, lastAdded);
        } else {
            boolean transactionalStore;
            lastAdded = cacheMode.isClustered() ? this.addInterceptor(interceptorChain, new ClusteredCacheLoaderInterceptor(), CacheLoaderInterceptor.class, lastAdded) : this.addInterceptor(interceptorChain, new CacheLoaderInterceptor(), CacheLoaderInterceptor.class, lastAdded);
            boolean bl = transactionalStore = cacheConfiguration.persistence().stores().stream().anyMatch(StoreConfiguration::transactional) || stores.stream().anyMatch(StoreConfiguration::transactional);
            if (transactionalStore && transactionMode.isTransactional()) {
                lastAdded = this.addInterceptor(interceptorChain, new TransactionalStoreInterceptor(), TransactionalStoreInterceptor.class, lastAdded);
            }
            switch (cacheMode) {
                case DIST_SYNC: 
                case REPL_SYNC: 
                case DIST_ASYNC: 
                case REPL_ASYNC: {
                    this.addInterceptor(interceptorChain, new DistCacheWriterInterceptor(), DistCacheWriterInterceptor.class, lastAdded);
                    break;
                }
                default: {
                    this.addInterceptor(interceptorChain, new CacheWriterInterceptor(), CacheWriterInterceptor.class, lastAdded);
                }
            }
        }
    }

    private boolean hasAsyncStore() {
        List<StoreConfiguration> loaderConfigs = this.configuration.persistence().stores();
        for (StoreConfiguration loaderConfig : loaderConfigs) {
            if (!loaderConfig.async().enabled()) continue;
            return true;
        }
        return false;
    }

    @Override
    public Object construct(String componentName) {
        try {
            if (this.configuration.simpleCache()) {
                return EmptyAsyncInterceptorChain.INSTANCE;
            }
            return this.buildInterceptorChain();
        }
        catch (CacheException ce) {
            throw ce;
        }
        catch (Exception e) {
            throw new CacheConfigurationException("Unable to build interceptor chain", (Throwable)e);
        }
    }
}

