/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.ext.auth;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.auth.PRNG;
import java.util.Objects;

@VertxGen
public interface VertxContextPRNG {
    public static VertxContextPRNG current() {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        throw new IllegalStateException("Not running in a Vert.x Context.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GenIgnore
    public static VertxContextPRNG current(Context context) {
        Objects.requireNonNull(context, "context can not be null");
        try {
            String contextKey = "__vertx.VertxContextPRNG";
            PRNG random = (PRNG)context.get((Object)"__vertx.VertxContextPRNG");
            if (random == null) {
                Context context2 = context;
                synchronized (context2) {
                    random = (PRNG)context.get((Object)"__vertx.VertxContextPRNG");
                    if (random == null) {
                        PRNG rand = random = new PRNG(context.owner());
                        context.put((Object)"__vertx.VertxContextPRNG", (Object)rand);
                    }
                }
            }
            return random;
        }
        catch (UnsupportedOperationException e) {
            Vertx vertx = context.owner();
            if (vertx != null) {
                return new PRNG(vertx);
            }
            throw new IllegalStateException("Not running in a Vert.x Context.");
        }
    }

    public static VertxContextPRNG current(Vertx vertx) {
        Context currentContext = Vertx.currentContext();
        if (currentContext != null) {
            return VertxContextPRNG.current(currentContext);
        }
        Objects.requireNonNull(vertx, "vertx can not be null");
        return new PRNG(vertx);
    }

    public void close();

    @GenIgnore(value={"permitted-type"})
    public void nextBytes(byte[] var1);

    public String nextString(int var1);

    public int nextInt();

    public int nextInt(int var1);

    public boolean nextBoolean();

    public long nextLong();

    public float nextFloat();

    public double nextDouble();

    public double nextGaussian();
}

