/*
 * Decompiled with CFR 0.152.
 */
package org.jgroups.protocols;

import java.io.Closeable;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.jgroups.Address;
import org.jgroups.EmptyMessage;
import org.jgroups.Event;
import org.jgroups.Header;
import org.jgroups.Membership;
import org.jgroups.Message;
import org.jgroups.PhysicalAddress;
import org.jgroups.View;
import org.jgroups.annotations.LocalAddress;
import org.jgroups.annotations.MBean;
import org.jgroups.annotations.ManagedAttribute;
import org.jgroups.annotations.ManagedOperation;
import org.jgroups.annotations.Property;
import org.jgroups.blocks.cs.Connection;
import org.jgroups.blocks.cs.ConnectionListener;
import org.jgroups.blocks.cs.NioServer;
import org.jgroups.blocks.cs.Receiver;
import org.jgroups.conf.AttributeType;
import org.jgroups.protocols.TCP;
import org.jgroups.protocols.TP;
import org.jgroups.stack.IpAddress;
import org.jgroups.stack.Protocol;
import org.jgroups.util.Bits;
import org.jgroups.util.BoundedList;
import org.jgroups.util.ByteArray;
import org.jgroups.util.ByteArrayDataInputStream;
import org.jgroups.util.ByteArrayDataOutputStream;
import org.jgroups.util.MessageBatch;
import org.jgroups.util.ProcessingQueue;
import org.jgroups.util.Promise;
import org.jgroups.util.TimeScheduler;
import org.jgroups.util.Util;

@MBean(description="Failure detection protocol based on sockets connecting members")
public class FD_SOCK2
extends Protocol
implements Receiver,
ConnectionListener,
ProcessingQueue.Handler<Request> {
    @LocalAddress
    @Property(description="The NIC on which the ServerSocket should listen on. The following special values are also recognized: GLOBAL, SITE_LOCAL, LINK_LOCAL and NON_LOOPBACK", systemProperty={"jgroups.bind_addr"}, writable=false)
    protected InetAddress bind_addr;
    @Property(description="Offset from the transport's bind port")
    protected int offset = 100;
    @Property(description="Number of ports to probe for finding a free port")
    protected int port_range = 3;
    @Property(description="Start port for client socket. Default value of 0 picks a random port")
    protected int client_bind_port;
    @Property(description="Use \"external_addr\" if you have hosts on different networks behind firewalls. On each firewall, set up a port forwarding rule to the local IP (e.g. 192.168.1.100) of the host, then on each host, set the \"external_addr\" TCP transport attribute to the external (public IP) address of the firewall", systemProperty={"jgroups.external_addr"}, writable=false)
    protected InetAddress external_addr;
    @Property(description="Used to map the internal port (bind_port) to an external port. Only used if > 0", systemProperty={"jgroups.external_port"}, writable=false)
    protected int external_port;
    @Property(description="Interval for broadcasting suspect messages", type=AttributeType.TIME)
    protected long suspect_msg_interval = 5000L;
    @Property(description="Max time (ms) to wait for a connect attempt", type=AttributeType.TIME)
    protected int connect_timeout = 1000;
    @Property(description="The lowest port the FD_SOCK server can listen on. Needed when wrapping around, looking for ports. See https://issues.redhat.com/browse/JGRP-2560 for details")
    protected int min_port = 1024;
    @Property(description="The highest port the FD_SOCK server can listen on. Needed when wrapping around, looking for ports. See https://issues.redhat.com/browse/JGRP-2560 for details.")
    protected int max_port = 65536;
    @Property(description="SO_LINGER in seconds. Default of -1 disables it")
    protected int linger = -1;
    @ManagedAttribute(description="Number of suspect events emitted")
    protected int num_suspect_events;
    @ManagedAttribute(description="True when this member is leaving the cluster, set to false when joining")
    protected volatile boolean shutting_down;
    @ManagedAttribute(description="List of pingable members of a cluster")
    protected final Membership pingable_mbrs = new Membership();
    @ManagedAttribute(description="List of the current cluster members")
    protected final Membership members = new Membership();
    @ManagedAttribute(description="List of currently suspected members")
    protected final Membership suspected_mbrs = new Membership();
    @ManagedAttribute(description="The cluster we've joined. Set on joining a cluster, null when unconnected")
    protected String cluster;
    protected NioServer srv;
    protected final PingDest ping_dest = new PingDest();
    protected TimeScheduler timer;
    protected final BroadcastTask bcast_task = new BroadcastTask();
    protected final ProcessingQueue<Request> req_handler = new ProcessingQueue<Request>().setHandler(this);
    protected final BoundedList<String> suspect_history = new BoundedList(20);

    @ManagedAttribute(description="The number of currently suspected members")
    public int getNumSuspectedMembers() {
        return this.suspected_mbrs.size();
    }

    @ManagedAttribute(description="Ping destination")
    public String getPingDest() {
        return String.format("%s", this.ping_dest);
    }

    @ManagedAttribute(description="The client state (CONNECTED / DISCONNECTED)")
    public String getClientState() {
        return this.ping_dest.clientState().toString();
    }

    public InetAddress getBindAddress() {
        return this.bind_addr;
    }

    public FD_SOCK2 setBindAddress(InetAddress b) {
        this.bind_addr = b;
        return this;
    }

    public InetAddress getExternalAddress() {
        return this.external_addr;
    }

    public FD_SOCK2 setExternalAddress(InetAddress e) {
        this.external_addr = e;
        return this;
    }

    public int getExternalPort() {
        return this.external_port;
    }

    public FD_SOCK2 setExternalPort(int e) {
        this.external_port = e;
        return this;
    }

    public long getSuspectMsgInterval() {
        return this.suspect_msg_interval;
    }

    public FD_SOCK2 setSuspectMsgInterval(long s) {
        this.suspect_msg_interval = s;
        return this;
    }

    public int getClientBindPort() {
        return this.client_bind_port;
    }

    public FD_SOCK2 setClientBindPort(int c) {
        this.client_bind_port = c;
        return this;
    }

    public int getPortRange() {
        return this.port_range;
    }

    public FD_SOCK2 setPortRange(int p) {
        this.port_range = p;
        return this;
    }

    public int getOffset() {
        return this.offset;
    }

    public FD_SOCK2 setOffset(int o) {
        this.offset = o;
        return this;
    }

    public int getLinger() {
        return this.linger;
    }

    public FD_SOCK2 setLinger(int l) {
        this.linger = l;
        return this;
    }

    @ManagedAttribute(description="Actual port the server is listening on")
    public int getActualBindPort() {
        Address addr = this.srv != null ? this.srv.localAddress() : null;
        return addr != null ? ((IpAddress)addr).getPort() : 0;
    }

    @ManagedOperation(description="Print suspect history")
    public String printSuspectHistory() {
        return String.join((CharSequence)"\n", this.suspect_history);
    }

    @ManagedOperation(description="Prints the connections to other FD_SOCK2 instances")
    public String printConnections() {
        return this.srv.printConnections();
    }

    @Override
    public void start() throws Exception {
        super.start();
        TP transport = this.getTransport();
        this.timer = transport.getTimer();
        if (this.timer == null) {
            throw new Exception("timer is null");
        }
        PhysicalAddress addr = transport.getPhysicalAddress();
        int actual_port = ((IpAddress)addr).getPort();
        int[] bind_ports = this.computeBindPorts(actual_port);
        this.srv = this.createServer(bind_ports);
        this.srv.receiver(this).clientBindPort(this.client_bind_port).usePeerConnections(true).addConnectionListener(this).linger(this.linger);
        this.srv.start();
        this.log.info("server listening on %s", this.bind_addr != null ? this.srv.getChannel().getLocalAddress() : "*." + this.getActualBindPort());
    }

    @Override
    public void stop() {
        Util.close((Closeable)this.srv);
        this.pingable_mbrs.clear();
        this.suspected_mbrs.clear();
        this.bcast_task.clear();
        this.ping_dest.reset();
    }

    @Override
    public void resetStats() {
        super.resetStats();
        this.num_suspect_events = 0;
        this.suspect_history.clear();
    }

    @Override
    public Object up(Message msg) {
        FdHeader hdr = (FdHeader)msg.getHeader(this.id);
        if (hdr == null) {
            return this.up_prot.up(msg);
        }
        return this.handle(hdr, msg.getSrc());
    }

    @Override
    public void up(MessageBatch batch) {
        Iterator<Message> it = batch.iterator();
        while (it.hasNext()) {
            Message msg = it.next();
            FdHeader hdr = (FdHeader)msg.getHeader(this.id);
            if (hdr == null) continue;
            it.remove();
            this.handle(hdr, msg.getSrc());
        }
        if (!batch.isEmpty()) {
            this.up_prot.up(batch);
        }
    }

    @Override
    public Object down(Event evt) {
        switch (evt.getType()) {
            case 51: {
                this.broadcastUnuspectMessage((Address)evt.getArg());
                break;
            }
            case 2: 
            case 80: 
            case 92: 
            case 93: {
                this.shutting_down = false;
                this.cluster = (String)evt.getArg();
                break;
            }
            case 4: {
                this.shutting_down = true;
                this.cluster = null;
                break;
            }
            case 6: {
                Object ret = this.down_prot.down(evt);
                this.handleView((View)evt.arg());
                return ret;
            }
        }
        return this.down_prot.down(evt);
    }

    @Override
    public void receive(Address sender, byte[] buf, int offset, int length) {
        try {
            this.receive(sender, new ByteArrayDataInputStream(buf, offset, length), length);
        }
        catch (Exception e) {
            this.log.error("failed handling message received from " + sender, e);
        }
    }

    @Override
    public void receive(Address sender, DataInput in, int length) throws Exception {
        EmptyMessage msg = new EmptyMessage();
        msg.readFrom(in);
        FdHeader hdr = (FdHeader)msg.getHeader(this.id);
        if (hdr == null) {
            throw new IllegalStateException(String.format("message from %s does not have a header (id=%d)", sender, this.id));
        }
        switch (hdr.type) {
            case 1: 
            case 2: {
                break;
            }
            case 3: {
                this.log.trace("%s: CONNECT <-- %s", this.local_addr, msg.src());
                FdHeader h = new FdHeader(4).cluster(this.cluster).serverAddress(this.local_addr);
                Message rsp = new EmptyMessage().setSrc(this.local_addr).putHeader(this.id, h);
                ByteArray buf = FD_SOCK2.messageToBuffer(rsp);
                this.log.trace("%s: CONNECT-RSP[cluster=%s, srv=%s] --> %s", this.local_addr, this.cluster, this.local_addr, msg.src());
                this.srv.send(sender, buf.getArray(), buf.getOffset(), buf.getLength());
                break;
            }
            case 4: {
                this.log.trace("%s: CONNECT-RSP <-- %s [cluster=%s, srv=%s]", this.local_addr, msg.src(), hdr.cluster, hdr.srv);
                if (Objects.equals(this.cluster, hdr.cluster) && Objects.equals(hdr.srv, this.ping_dest.dest())) {
                    this.ping_dest.clientState(State.CONNECTED).setConnectResult(true);
                    break;
                }
                this.log.trace("%s: addresses don't match: my ping-dest=%s, server's address=%s", this.local_addr, this.ping_dest.dest(), hdr.srv);
                this.ping_dest.setConnectResult(false);
                break;
            }
            default: {
                throw new IllegalStateException(String.format("type %d not known", hdr.type));
            }
        }
    }

    @Override
    public void connectionEstablished(Connection conn) {
        this.log.trace("%s: created connection to %s", this.local_addr, conn.peerAddress());
    }

    @Override
    public void connectionClosed(Connection conn) {
        Address dest;
        Address peer;
        Address address = peer = conn != null ? conn.peerAddress() : null;
        if (peer != null && Objects.equals(peer, this.ping_dest.destPhysical()) && !this.shutting_down && (dest = this.ping_dest.dest()) != null) {
            this.log.debug("%s: connection to %s closed", this.local_addr, dest);
            this.pingable_mbrs.remove(dest);
            CompletableFuture.runAsync(() -> this.req_handler.add(new Request(Request.Type.ConnectToNextPingDest, dest)));
        }
    }

    protected Object handle(FdHeader hdr, Address sender) {
        switch (hdr.type) {
            case 1: {
                if (hdr.mbrs == null) break;
                this.log.trace("%s: received SUSPECT message from %s: suspects=%s", this.local_addr, sender, hdr.mbrs);
                this.suspect(hdr.mbrs);
                break;
            }
            case 2: {
                if (hdr.mbrs == null) break;
                this.log.trace("%s: received UNSUSPECT message from %s: mbrs=%s", this.local_addr, sender, hdr.mbrs);
                hdr.mbrs.forEach(this::unsuspect);
                this.req_handler.add(new Request(Request.Type.ConnectToNextPingDest, null));
            }
        }
        return null;
    }

    protected NioServer createServer(int[] bind_ports) {
        for (int bind_port : bind_ports) {
            try {
                return new NioServer(this.getThreadFactory(), this.getSocketFactory(), this.bind_addr, bind_port, bind_port, this.external_addr, this.external_port, 0, "jgroups.nio.server.fd_sock");
            }
            catch (Exception exception) {
            }
        }
        throw new IllegalStateException(String.format("%s: failed to find an available port in ports %s", this.local_addr, Arrays.toString(bind_ports)));
    }

    protected void closeConnectionToPingDest() {
        if (!this.ping_dest.connected()) {
            return;
        }
        try {
            this.ping_dest.clientState(State.DISCONNECTED);
            if (!this.srv.closeConnection(this.ping_dest.destPhysical(), false)) {
                return;
            }
            this.log.debug("%s: connection to %s closed", this.local_addr, this.ping_dest);
        }
        finally {
            this.ping_dest.reset();
        }
    }

    @Override
    public void handle(Request req) throws Exception {
        switch (req.type) {
            case ConnectToNextPingDest: {
                this.connectToNextPingDest(req.suspect);
                break;
            }
            case CloseConnectionToPingDest: {
                this.closeConnectionToPingDest();
            }
        }
    }

    protected void handleView(View v) {
        List<Address> new_mbrs = v.getMembers();
        this.members.set(new_mbrs);
        this.suspected_mbrs.retainAll(new_mbrs);
        this.bcast_task.adjustSuspects(new_mbrs);
        this.pingable_mbrs.set(new_mbrs);
        if (v.size() < 2) {
            this.req_handler.add(new Request(Request.Type.CloseConnectionToPingDest, null));
        } else {
            this.req_handler.add(new Request(Request.Type.ConnectToNextPingDest, null));
        }
    }

    protected void connectToNextPingDest(Address already_suspect) {
        Address new_ping_dest;
        boolean hasNewPingDest;
        ArrayList<Address> suspected_members = new ArrayList<Address>();
        if (already_suspect != null) {
            suspected_members.add(already_suspect);
        }
        while (!this.pingable_mbrs.isEmpty() && (hasNewPingDest = this.ping_dest.destChanged(new_ping_dest = this.pingable_mbrs.getNext(this.local_addr))) && !this.connectTo(new_ping_dest, this.members)) {
            if (this.ping_dest.connected()) continue;
            this.pingable_mbrs.remove(new_ping_dest);
            suspected_members.add(new_ping_dest);
        }
        if (!suspected_members.isEmpty()) {
            this.broadcastSuspectMessage(suspected_members);
        }
    }

    protected boolean connectTo(Address new_ping_dest, Membership mbrs) {
        Address old_dest = this.ping_dest.dest();
        IpAddress old_dest_physical = this.ping_dest.destPhysical();
        List<IpAddress> dests = this.getPhysicalAddresses(new_ping_dest);
        this.ping_dest.reset().dest(new_ping_dest);
        this.log.debug("%s: trying to connect to %s", this.local_addr, new_ping_dest);
        long start = System.currentTimeMillis();
        for (IpAddress d : dests) {
            if (!this.connectTo(d, new_ping_dest)) continue;
            long time = System.currentTimeMillis() - start;
            this.ping_dest.dest(new_ping_dest).destPhysical(d).clientState(State.CONNECTED);
            this.log.debug("%s: connected successfully to %s (%s) in %d ms", this.local_addr, this.ping_dest.dest(), d, time);
            Address left_mbr = mbrs.getPrevious(this.local_addr);
            if (old_dest != null && !Objects.equals(old_dest, left_mbr)) {
                this.srv.closeConnection(old_dest_physical, false);
                this.log.trace("%s: closed connection to previous ping-dest %s (%s)", this.local_addr, old_dest, old_dest_physical);
            }
            return true;
        }
        return false;
    }

    protected boolean connectTo(IpAddress dest, Address logical_addr) {
        Message msg = new EmptyMessage().setSrc(this.local_addr).putHeader(this.id, new FdHeader(3).serverAddress(logical_addr));
        try {
            ByteArray buf = FD_SOCK2.messageToBuffer(msg);
            this.log.trace("%s: CONNECT --> %s (%s)", this.local_addr, logical_addr, dest);
            this.ping_dest.resetConnectResult();
            boolean existing_connection = this.srv.hasConnection(dest);
            this.srv.send(dest, buf.getArray(), buf.getOffset(), buf.getLength());
            this.ping_dest.waitForConnect(this.connect_timeout);
            if (this.ping_dest.connected()) {
                return true;
            }
            if (!existing_connection) {
                this.srv.closeConnection(dest);
            }
            return false;
        }
        catch (Exception ex) {
            this.log.trace("%s: failed connecting to %s: %s", this.local_addr, dest, ex.getMessage());
            return false;
        }
    }

    protected List<IpAddress> getPhysicalAddresses(Address a) {
        IpAddress pa = (IpAddress)this.down_prot.down(new Event(87, a));
        if (pa == null) {
            return Collections.emptyList();
        }
        InetAddress addr = pa.getIpAddress();
        int actual_port = pa.getPort();
        int[] bind_ports = this.computeBindPorts(actual_port);
        return IntStream.of(bind_ports).boxed().map(p -> new IpAddress(addr, (int)p)).collect(Collectors.toList());
    }

    public static ByteArray messageToBuffer(Message msg) throws Exception {
        ByteArrayDataOutputStream out = new ByteArrayDataOutputStream(msg.size());
        msg.writeTo(out);
        return out.getBuffer();
    }

    protected int[] computeBindPorts(int actual_port) {
        int[] bind_ports = new int[this.port_range + 1];
        for (int i = 0; i <= this.port_range; ++i) {
            int port = (actual_port + this.offset + i) % this.max_port;
            if (port < this.min_port) {
                port += this.min_port;
            }
            bind_ports[i] = port;
        }
        return bind_ports;
    }

    protected void suspect(Collection<Address> suspects) {
        if (suspects == null) {
            return;
        }
        suspects.remove(this.local_addr);
        suspects.forEach(suspect -> this.suspect_history.add(String.format("%s: %s", Util.utcNow(), suspect)));
        this.suspected_mbrs.add(suspects);
        List<Address> suspects_copy = this.suspected_mbrs.getMembers();
        if (suspects_copy.isEmpty()) {
            return;
        }
        Membership eligible_mbrs = this.members.copy().remove(this.suspected_mbrs.getMembers());
        if (eligible_mbrs.isCoord(this.local_addr)) {
            this.log.debug("%s: suspecting %s", this.local_addr, suspects_copy);
            this.up_prot.up(new Event(9, suspects_copy));
            this.down_prot.down(new Event(9, suspects_copy));
        }
    }

    protected void unsuspect(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.suspected_mbrs.remove(mbr);
        this.bcast_task.removeSuspect(mbr);
        this.pingable_mbrs.add(mbr);
    }

    protected void broadcastSuspectMessage(List<Address> suspected_members) {
        if (suspected_members == null || suspected_members.isEmpty()) {
            return;
        }
        this.log.debug("%s: broadcasting suspect(%s)", this.local_addr, suspected_members);
        FdHeader hdr = new FdHeader(1).mbrs(suspected_members);
        Message suspect_msg = new EmptyMessage().putHeader(this.id, hdr);
        this.down_prot.down(suspect_msg);
        this.bcast_task.addSuspects(suspected_members);
        if (this.stats) {
            ++this.num_suspect_events;
        }
    }

    protected void broadcastUnuspectMessage(Address mbr) {
        if (mbr == null) {
            return;
        }
        this.log.debug("%s: broadcasting unsuspect(%s)", this.local_addr, mbr);
        FdHeader hdr = new FdHeader(2).mbrs(Collections.singleton(mbr));
        Message suspect_msg = new EmptyMessage().putHeader(this.id, hdr).setFlag(Message.TransientFlag.DONT_BLOCK);
        this.down_prot.down(suspect_msg);
    }

    protected class BroadcastTask
    implements Runnable {
        protected final Set<Address> suspects = new HashSet<Address>();
        protected Future<?> future;

        protected BroadcastTask() {
        }

        protected synchronized void addSuspects(List<Address> mbrs) {
            if (mbrs == null || mbrs.isEmpty()) {
                return;
            }
            ArrayList<Address> tmp = new ArrayList<Address>(mbrs);
            tmp.retainAll(FD_SOCK2.this.members.getMembers());
            if (this.suspects.addAll(tmp)) {
                this.startTask();
            }
        }

        protected synchronized void removeSuspect(Address suspect) {
            if (suspect == null) {
                return;
            }
            if (this.suspects.remove(suspect) && this.suspects.isEmpty()) {
                this.stopTask();
            }
        }

        protected synchronized void adjustSuspects(List<Address> mbrs) {
            if (mbrs == null || mbrs.isEmpty()) {
                return;
            }
            if (this.suspects.retainAll(mbrs) && this.suspects.isEmpty()) {
                this.stopTask();
            }
        }

        protected synchronized void clear() {
            this.suspects.clear();
            this.stopTask();
        }

        protected void startTask() {
            if (this.future == null || this.future.isDone()) {
                this.future = FD_SOCK2.this.timer.scheduleWithFixedDelay(this, FD_SOCK2.this.suspect_msg_interval, FD_SOCK2.this.suspect_msg_interval, TimeUnit.MILLISECONDS, FD_SOCK2.this.getTransport() instanceof TCP);
            }
        }

        protected void stopTask() {
            if (this.future != null) {
                this.future.cancel(false);
                this.future = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            FdHeader hdr;
            FD_SOCK2.this.log.trace("%s: broadcasting SUSPECT message (suspected_mbrs=%s)", FD_SOCK2.this.local_addr, this.suspects);
            BroadcastTask broadcastTask = this;
            synchronized (broadcastTask) {
                if (this.suspects.isEmpty()) {
                    this.stopTask();
                    return;
                }
                hdr = new FdHeader(1).mbrs(new HashSet<Address>(this.suspects));
            }
            Message suspect_msg = new EmptyMessage().putHeader(FD_SOCK2.this.id, hdr);
            FD_SOCK2.this.down_prot.down(suspect_msg);
        }

        public String toString() {
            return FD_SOCK2.class.getSimpleName() + ": " + this.getClass().getSimpleName();
        }
    }

    protected static class Request {
        protected final Type type;
        protected final Address suspect;

        public Request(Type type, Address suspect) {
            this.type = type;
            this.suspect = suspect;
        }

        public String toString() {
            return String.format("%s (suspect=%s)", new Object[]{this.type, this.suspect});
        }

        protected static enum Type {
            ConnectToNextPingDest,
            CloseConnectionToPingDest;

        }
    }

    public static class FdHeader
    extends Header {
        public static final byte SUSPECT = 1;
        public static final byte UNSUSPECT = 2;
        public static final byte CONNECT = 3;
        public static final byte CONNECT_RSP = 4;
        protected byte type;
        protected Collection<Address> mbrs;
        protected Address srv;
        protected String cluster;

        public FdHeader() {
        }

        public FdHeader(byte type) {
            this.type = type;
        }

        @Override
        public short getMagicId() {
            return 93;
        }

        @Override
        public Supplier<? extends Header> create() {
            return FdHeader::new;
        }

        public FdHeader mbrs(Collection<Address> m) {
            this.mbrs = m;
            return this;
        }

        public FdHeader serverAddress(Address a) {
            this.srv = a;
            return this;
        }

        public FdHeader cluster(String name) {
            this.cluster = name;
            return this;
        }

        @Override
        public int serializedSize() {
            int retval = 5;
            if (this.mbrs != null) {
                for (Address m : this.mbrs) {
                    retval += Util.size(m);
                }
            }
            return retval += Util.size(this.cluster) + Util.size(this.srv);
        }

        @Override
        public void writeTo(DataOutput out) throws IOException {
            out.writeByte(this.type);
            int size = this.mbrs != null ? this.mbrs.size() : 0;
            out.writeInt(size);
            if (size > 0) {
                for (Address address : this.mbrs) {
                    Util.writeAddress(address, out);
                }
            }
            Bits.writeString(this.cluster, out);
            Util.writeAddress(this.srv, out);
        }

        @Override
        public void readFrom(DataInput in) throws IOException, ClassNotFoundException {
            this.type = in.readByte();
            int size = in.readInt();
            if (size > 0) {
                this.mbrs = new HashSet<Address>();
                for (int i = 0; i < size; ++i) {
                    this.mbrs.add(Util.readAddress(in));
                }
            }
            this.cluster = Bits.readString(in);
            this.srv = Util.readAddress(in);
        }

        @Override
        public String toString() {
            return String.format("%s%s%s%s", FdHeader.type2String(this.type), this.mbrs != null ? ", mbrs=" + this.mbrs : "", this.srv != null ? ", srv=" + this.srv : "", this.cluster != null ? ", cluster=" + this.cluster : "");
        }

        protected static String type2String(byte type) {
            switch (type) {
                case 1: {
                    return "SUSPECT";
                }
                case 2: {
                    return "UNSUSPECT";
                }
                case 3: {
                    return "CONNECT";
                }
                case 4: {
                    return "CONNECT_RSP";
                }
            }
            return "unknown type (" + type + ")";
        }
    }

    protected static class PingDest {
        protected Address dest;
        protected IpAddress dest_physical;
        protected State client_state = State.DISCONNECTED;
        protected final Promise<Boolean> connect_promise = new Promise();

        protected PingDest() {
        }

        protected Address dest() {
            return this.dest;
        }

        protected PingDest dest(Address d) {
            this.dest = d;
            return this;
        }

        protected IpAddress destPhysical() {
            return this.dest_physical;
        }

        protected PingDest destPhysical(IpAddress d) {
            this.dest_physical = d;
            return this;
        }

        protected State clientState() {
            return this.client_state;
        }

        protected PingDest clientState(State s) {
            this.client_state = s;
            return this;
        }

        protected boolean connected() {
            return this.client_state == State.CONNECTED;
        }

        protected boolean destChanged(Address a) {
            return a != null && !Objects.equals(a, this.dest);
        }

        protected void waitForConnect(long time) {
            this.connect_promise.getResult(time);
        }

        protected PingDest setConnectResult(boolean b) {
            this.connect_promise.setResult(b);
            return this;
        }

        protected PingDest resetConnectResult() {
            this.connect_promise.reset(true);
            return this;
        }

        protected PingDest reset() {
            this.dest_physical = null;
            this.dest = null;
            this.client_state = State.DISCONNECTED;
            this.connect_promise.reset(true);
            return this;
        }

        public String toString() {
            return String.format("%s [%s %s]", new Object[]{this.dest, this.dest_physical, this.client_state});
        }
    }

    protected static enum State {
        DISCONNECTED,
        CONNECTED;

    }
}

