/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.services.managers;

import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.cookie.CookieProvider;
import org.keycloak.cookie.CookieType;
import org.keycloak.forms.login.LoginFormsProvider;
import org.keycloak.models.ClientModel;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.models.utils.SessionExpiration;
import org.keycloak.protocol.RestartLoginCookie;
import org.keycloak.services.managers.AuthSessionId;
import org.keycloak.sessions.AuthenticationSessionModel;
import org.keycloak.sessions.RootAuthenticationSessionModel;
import org.keycloak.sessions.StickySessionEncoderProvider;

public class AuthenticationSessionManager {
    private static final Logger log = Logger.getLogger(AuthenticationSessionManager.class);
    private final KeycloakSession session;

    public AuthenticationSessionManager(KeycloakSession session) {
        this.session = session;
    }

    public RootAuthenticationSessionModel createAuthenticationSession(RealmModel realm, boolean browserCookie) {
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().createRootAuthenticationSession(realm);
        if (browserCookie) {
            this.setAuthSessionCookie(rootAuthSession.getId());
        }
        return rootAuthSession;
    }

    public RootAuthenticationSessionModel getCurrentRootAuthenticationSession(RealmModel realm) {
        String oldEncodedId = this.getAuthSessionCookies(realm);
        if (oldEncodedId == null) {
            return null;
        }
        AuthSessionId authSessionId = this.decodeAuthSessionId(oldEncodedId);
        String sessionId = authSessionId.getDecodedId();
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(realm, sessionId);
        if (rootAuthSession != null) {
            this.reencodeAuthSessionCookie(oldEncodedId, authSessionId, realm);
            return rootAuthSession;
        }
        return null;
    }

    public AuthenticationSessionModel getCurrentAuthenticationSession(RealmModel realm, ClientModel client, String tabId) {
        String oldEncodedId = this.getAuthSessionCookies(realm);
        if (oldEncodedId == null) {
            return null;
        }
        AuthSessionId authSessionId = this.decodeAuthSessionId(oldEncodedId);
        String sessionId = authSessionId.getDecodedId();
        AuthenticationSessionModel authSession = this.getAuthenticationSessionByIdAndClient(realm, sessionId, client, tabId);
        if (authSession != null) {
            this.reencodeAuthSessionCookie(oldEncodedId, authSessionId, realm);
            return authSession;
        }
        return null;
    }

    public void setAuthSessionCookie(String authSessionId) {
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String encodedAuthSessionId = encoder.encodeSessionId(authSessionId);
        ((CookieProvider)this.session.getProvider(CookieProvider.class)).set(CookieType.AUTH_SESSION_ID, encodedAuthSessionId);
        log.debugf("Set AUTH_SESSION_ID cookie with value %s", (Object)encodedAuthSessionId);
    }

    AuthSessionId decodeAuthSessionId(String encodedAuthSessionId) {
        log.debugf("Found AUTH_SESSION_ID cookie with value %s", (Object)encodedAuthSessionId);
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String decodedAuthSessionId = encoder.decodeSessionId(encodedAuthSessionId);
        String reencoded = encoder.encodeSessionId(decodedAuthSessionId);
        return new AuthSessionId(decodedAuthSessionId, reencoded);
    }

    void reencodeAuthSessionCookie(String oldEncodedAuthSessionId, AuthSessionId newAuthSessionId, RealmModel realm) {
        if (!oldEncodedAuthSessionId.equals(newAuthSessionId.getEncodedId())) {
            log.debugf("Route changed. Will update authentication session cookie. Old: '%s', New: '%s'", (Object)oldEncodedAuthSessionId, (Object)newAuthSessionId.getEncodedId());
            this.setAuthSessionCookie(newAuthSessionId.getDecodedId());
        }
    }

    String getAuthSessionCookies(RealmModel realm) {
        String oldEncodedId = ((CookieProvider)this.session.getProvider(CookieProvider.class)).get(CookieType.AUTH_SESSION_ID);
        if (oldEncodedId == null || oldEncodedId.isEmpty()) {
            return null;
        }
        StickySessionEncoderProvider encoder = (StickySessionEncoderProvider)this.session.getProvider(StickySessionEncoderProvider.class);
        String decodedId = encoder.decodeSessionId(oldEncodedId);
        RootAuthenticationSessionModel rootAuthenticationSession = this.session.authenticationSessions().getRootAuthenticationSession(realm, decodedId);
        return rootAuthenticationSession != null ? oldEncodedId : null;
    }

    public void removeAuthenticationSession(RealmModel realm, AuthenticationSessionModel authSession, boolean expireRestartCookie) {
        RootAuthenticationSessionModel rootAuthSession = authSession.getParentSession();
        log.debugf("Removing root authSession '%s'. Expire restart cookie: %b", (Object)rootAuthSession.getId(), (Object)expireRestartCookie);
        this.session.authenticationSessions().removeRootAuthenticationSession(realm, rootAuthSession);
        if (expireRestartCookie) {
            RestartLoginCookie.expireRestartCookie(this.session);
            ((LoginFormsProvider)this.session.getProvider(LoginFormsProvider.class)).setDetachedAuthSession();
        }
    }

    public boolean removeTabIdInAuthenticationSession(RealmModel realm, AuthenticationSessionModel authSession) {
        RootAuthenticationSessionModel rootAuthSession = authSession.getParentSession();
        rootAuthSession.removeAuthenticationSessionByTabId(authSession.getTabId());
        if (rootAuthSession.getAuthenticationSessions().isEmpty()) {
            this.removeAuthenticationSession(realm, authSession, true);
            return true;
        }
        return false;
    }

    public void updateAuthenticationSessionAfterSuccessfulAuthentication(RealmModel realm, AuthenticationSessionModel authSession) {
        boolean removedRootAuthSession = this.removeTabIdInAuthenticationSession(realm, authSession);
        if (!removedRootAuthSession) {
            if (realm.getSsoSessionIdleTimeout() < SessionExpiration.getAuthSessionLifespan((RealmModel)realm) && realm.getSsoSessionMaxLifespan() < SessionExpiration.getAuthSessionLifespan((RealmModel)realm)) {
                this.removeAuthenticationSession(realm, authSession, true);
            } else {
                RootAuthenticationSessionModel rootAuthSession = authSession.getParentSession();
                int authSessionExpiresIn = realm.getAccessCodeLifespan();
                int authSessionExpirationTime = Time.currentTime() - SessionExpiration.getAuthSessionLifespan((RealmModel)realm) + authSessionExpiresIn;
                rootAuthSession.setTimestamp(authSessionExpirationTime);
                log.tracef("Removed authentication session of root session '%s' with tabId '%s'. But there are remaining tabs in the root session. Root authentication session will expire in %d seconds", (Object)rootAuthSession.getId(), (Object)authSession.getTabId(), (Object)authSessionExpiresIn);
            }
        }
    }

    public UserSessionModel getUserSession(AuthenticationSessionModel authSession) {
        return this.session.sessions().getUserSession(authSession.getRealm(), authSession.getParentSession().getId());
    }

    public AuthenticationSessionModel getAuthenticationSessionByIdAndClient(RealmModel realm, String authSessionId, ClientModel client, String tabId) {
        RootAuthenticationSessionModel rootAuthSession = this.session.authenticationSessions().getRootAuthenticationSession(realm, authSessionId);
        return rootAuthSession == null ? null : rootAuthSession.getAuthenticationSession(client, tabId);
    }
}

