/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oid4vc.issuance.signing.vcdm;

import com.apicatalog.jsonld.JsonLd;
import com.apicatalog.jsonld.JsonLdError;
import com.apicatalog.jsonld.document.Document;
import com.apicatalog.jsonld.document.JsonDocument;
import com.apicatalog.jsonld.http.DefaultHttpClient;
import com.apicatalog.jsonld.http.media.MediaType;
import com.apicatalog.jsonld.json.JsonUtils;
import com.apicatalog.jsonld.loader.DocumentLoader;
import com.apicatalog.jsonld.loader.HttpLoader;
import com.apicatalog.rdf.Rdf;
import com.apicatalog.rdf.RdfDataset;
import com.apicatalog.rdf.io.RdfWriter;
import com.apicatalog.rdf.io.error.RdfWriterException;
import com.apicatalog.rdf.io.error.UnsupportedContentException;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.setl.rdf.normalization.RdfNormalize;
import jakarta.json.JsonArray;
import jakarta.json.JsonStructure;
import jakarta.json.JsonValue;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Optional;
import org.keycloak.crypto.SignatureSignerContext;
import org.keycloak.protocol.oid4vc.issuance.signing.SigningServiceException;
import org.keycloak.protocol.oid4vc.issuance.signing.vcdm.LinkedDataCryptographicSuite;
import org.keycloak.protocol.oid4vc.model.VerifiableCredential;

public class Ed255192018Suite
implements LinkedDataCryptographicSuite {
    private final ObjectMapper objectMapper;
    private final SignatureSignerContext signerContext;
    public static final String PROOF_TYPE = "Ed25519Signature2018";

    public Ed255192018Suite(ObjectMapper objectMapper, SignatureSignerContext signerContext) {
        this.objectMapper = objectMapper;
        this.signerContext = signerContext;
    }

    @Override
    public byte[] getSignature(VerifiableCredential verifiableCredential) {
        byte[] transformedData = this.transform(verifiableCredential);
        byte[] hashedData = this.digest(transformedData);
        return this.sign(hashedData);
    }

    private byte[] transform(VerifiableCredential verifiableCredential) {
        try {
            String credentialString = this.objectMapper.writeValueAsString((Object)verifiableCredential);
            JsonDocument credentialDocument = JsonDocument.of((Reader)new StringReader(credentialString));
            JsonArray expandedDocument = JsonLd.expand((Document)credentialDocument).loader((DocumentLoader)new HttpLoader(DefaultHttpClient.defaultInstance())).get();
            Optional<Object> documentObject = Optional.empty();
            if (JsonUtils.isArray((JsonValue)expandedDocument)) {
                documentObject = expandedDocument.asJsonArray().stream().filter(JsonUtils::isObject).map(JsonValue::asJsonObject).findFirst();
            } else if (JsonUtils.isObject((JsonValue)expandedDocument)) {
                documentObject = Optional.of(expandedDocument.asJsonObject());
            }
            if (documentObject.isPresent()) {
                RdfDataset rdfDataset = JsonLd.toRdf((Document)JsonDocument.of((JsonStructure)((JsonStructure)documentObject.get()))).get();
                RdfDataset canonicalDataset = RdfNormalize.normalize((RdfDataset)rdfDataset);
                StringWriter writer = new StringWriter();
                RdfWriter rdfWriter = Rdf.createWriter((MediaType)MediaType.N_QUADS, (Writer)writer);
                rdfWriter.write(canonicalDataset);
                return writer.toString().getBytes(StandardCharsets.UTF_8);
            }
            throw new SigningServiceException("Was not able to get the expanded json.");
        }
        catch (JsonProcessingException e) {
            throw new SigningServiceException("Was not able to serialize the credential", e);
        }
        catch (JsonLdError e) {
            throw new SigningServiceException("Was not able to create a JsonLD Document from the serialized string.", e);
        }
        catch (RdfWriterException | UnsupportedContentException | IOException e) {
            throw new SigningServiceException("Was not able to canonicalize the json-ld.", e);
        }
    }

    private byte[] digest(byte[] transformedData) {
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            return md.digest(transformedData);
        }
        catch (NoSuchAlgorithmException e) {
            throw new SigningServiceException("Algorithm SHA-256 not supported.", e);
        }
    }

    private byte[] sign(byte[] hashData) {
        return this.signerContext.sign(hashData);
    }

    @Override
    public String getProofType() {
        return PROOF_TYPE;
    }
}

