/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.micrometer.runtime.registry.json;

import io.micrometer.core.instrument.AbstractDistributionSummary;
import io.micrometer.core.instrument.Clock;
import io.micrometer.core.instrument.Measurement;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.distribution.DistributionStatisticConfig;
import io.micrometer.core.instrument.distribution.TimeWindowMax;
import io.quarkus.micrometer.runtime.registry.json.TimeWindowMin;
import java.util.Arrays;
import java.util.concurrent.atomic.DoubleAdder;
import java.util.concurrent.atomic.LongAdder;

public class JsonDistributionSummary
extends AbstractDistributionSummary {
    private final LongAdder count = new LongAdder();
    private final DoubleAdder total = new DoubleAdder();
    private final TimeWindowMax max;
    private final TimeWindowMin min;

    public JsonDistributionSummary(Meter.Id id, Clock clock, DistributionStatisticConfig distributionStatisticConfig, double scale, boolean supportsAggregablePercentiles) {
        super(id, clock, distributionStatisticConfig, scale, supportsAggregablePercentiles);
        this.max = new TimeWindowMax(clock, distributionStatisticConfig);
        this.min = new TimeWindowMin(clock, distributionStatisticConfig);
    }

    protected void recordNonNegative(double amount) {
        this.count.increment();
        this.total.add(amount);
        this.max.record(amount);
        this.min.record(amount);
    }

    public long count() {
        return this.count.longValue();
    }

    public double totalAmount() {
        return this.total.sum();
    }

    public double max() {
        return this.max.poll();
    }

    public double min() {
        return this.min.poll();
    }

    public Iterable<Measurement> measure() {
        return Arrays.asList(new Measurement(() -> this.count(), Statistic.COUNT), new Measurement(this::totalAmount, Statistic.TOTAL), new Measurement(this::max, Statistic.MAX));
    }
}

