/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.httpcomponents.hc5;

import io.micrometer.common.KeyValue;
import io.micrometer.common.KeyValues;
import io.micrometer.common.docs.KeyName;
import io.micrometer.common.lang.Nullable;
import io.micrometer.core.instrument.binder.http.Outcome;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientContext;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationConvention;
import io.micrometer.core.instrument.binder.httpcomponents.hc5.ApacheHttpClientObservationDocumentation;
import java.io.IOException;
import org.apache.hc.client5.http.HttpRoute;
import org.apache.hc.client5.http.RouteInfo;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.HttpException;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.HttpResponse;

public class DefaultApacheHttpClientObservationConvention
implements ApacheHttpClientObservationConvention {
    public static final DefaultApacheHttpClientObservationConvention INSTANCE = new DefaultApacheHttpClientObservationConvention();
    private static final KeyValue METHOD_UNKNOWN = KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD, (String)"UNKNOWN");
    private static final KeyValue URI_UNKNOWN = KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI, (String)"UNKNOWN");
    private static final KeyValue STATUS_IO_ERROR = KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS, (String)"IO_ERROR");
    private static final KeyValue STATUS_CLIENT_ERROR = KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS, (String)"CLIENT_ERROR");
    private static final KeyValue EXCEPTION_NONE = KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.EXCEPTION, (String)"none");

    protected DefaultApacheHttpClientObservationConvention() {
    }

    public String getName() {
        return "httpcomponents.httpclient.request";
    }

    public String getContextualName(ApacheHttpClientContext context) {
        HttpRequest request = (HttpRequest)context.getCarrier();
        String methodName = "UNKNOWN";
        if (request != null && request.getMethod() != null) {
            methodName = request.getMethod();
        }
        return "HTTP " + methodName;
    }

    public KeyValues getLowCardinalityKeyValues(ApacheHttpClientContext context) {
        return KeyValues.of((KeyValue[])new KeyValue[]{this.exception(context), this.method(context), this.outcome(context), this.status(context), this.targetHost(context), this.targetPort(context), this.targetScheme(context), this.uri(context)});
    }

    protected KeyValue exception(ApacheHttpClientContext context) {
        Throwable error = context.getError();
        if (error != null) {
            return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.EXCEPTION, (String)error.getClass().getSimpleName());
        }
        return EXCEPTION_NONE;
    }

    protected KeyValue method(ApacheHttpClientContext context) {
        HttpRequest request = (HttpRequest)context.getCarrier();
        if (request == null || request.getMethod() == null) {
            return METHOD_UNKNOWN;
        }
        return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.METHOD.withValue(request.getMethod());
    }

    protected KeyValue outcome(ApacheHttpClientContext context) {
        HttpResponse response = (HttpResponse)context.getResponse();
        if (response == null) {
            return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME, (String)Outcome.UNKNOWN.name());
        }
        return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.OUTCOME, (String)Outcome.forStatus(response.getCode()).name());
    }

    protected KeyValue status(ApacheHttpClientContext context) {
        Throwable error = context.getError();
        HttpResponse response = (HttpResponse)context.getResponse();
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return STATUS_IO_ERROR;
        }
        if (response == null) {
            return STATUS_CLIENT_ERROR;
        }
        return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.STATUS, (String)Integer.toString(response.getCode()));
    }

    protected KeyValue targetHost(ApacheHttpClientContext context) {
        RouteInfo httpRoute = context.getHttpClientContext().getHttpRoute();
        if (httpRoute != null) {
            return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_HOST, (String)httpRoute.getTargetHost().getHostName());
        }
        return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_HOST, (String)"UNKNOWN");
    }

    protected KeyValue targetPort(ApacheHttpClientContext context) {
        Object routeAttribute = context.getHttpClientContext().getAttribute("http.route");
        if (routeAttribute instanceof HttpRoute) {
            int port = ((HttpRoute)routeAttribute).getTargetHost().getPort();
            return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_PORT, (String)String.valueOf(port));
        }
        return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_PORT, (String)"UNKNOWN");
    }

    protected KeyValue targetScheme(ApacheHttpClientContext context) {
        Object routeAttribute = context.getHttpClientContext().getAttribute("http.route");
        if (routeAttribute instanceof HttpRoute) {
            return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_SCHEME, (String)((HttpRoute)routeAttribute).getTargetHost().getSchemeName());
        }
        return KeyValue.of((KeyName)ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.TARGET_SCHEME, (String)"UNKNOWN");
    }

    protected KeyValue uri(ApacheHttpClientContext context) {
        HttpClientContext clientContext = context.getHttpClientContext();
        String uriTemplate = (String)clientContext.getAttribute("micrometer.uri.template");
        if (uriTemplate != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(uriTemplate);
        }
        if (context.getCarrier() != null) {
            return ApacheHttpClientObservationDocumentation.ApacheHttpClientKeyNames.URI.withValue(context.getUriMapper().apply((HttpRequest)context.getCarrier()));
        }
        return URI_UNKNOWN;
    }

    @Deprecated
    Outcome getStatusOutcome(@Nullable HttpResponse response) {
        return response != null ? Outcome.forStatus(response.getCode()) : Outcome.UNKNOWN;
    }

    @Deprecated
    String getStatusValue(@Nullable HttpResponse response, Throwable error) {
        if (error instanceof IOException || error instanceof HttpException || error instanceof RuntimeException) {
            return "IO_ERROR";
        }
        return response != null ? Integer.toString(response.getCode()) : "CLIENT_ERROR";
    }

    @Deprecated
    String getMethodString(@Nullable HttpRequest request) {
        return request != null && request.getMethod() != null ? request.getMethod() : "UNKNOWN";
    }
}

