/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.mutiny.operators.uni;

import io.smallrye.mutiny.Uni;
import io.smallrye.mutiny.helpers.ParameterValidation;
import io.smallrye.mutiny.operators.AbstractUni;
import io.smallrye.mutiny.operators.UniOperator;
import io.smallrye.mutiny.operators.uni.UniOperatorProcessor;
import io.smallrye.mutiny.subscription.UniSubscriber;
import java.util.function.Function;

public class UniOnItemTransform<I, O>
extends UniOperator<I, O> {
    private final Function<? super I, ? extends O> mapper;

    public UniOnItemTransform(Uni<I> source, Function<? super I, ? extends O> mapper) {
        super(ParameterValidation.nonNull(source, "source"));
        this.mapper = mapper;
    }

    @Override
    public void subscribe(UniSubscriber<? super O> subscriber) {
        AbstractUni.subscribe(this.upstream(), new UniOnItemTransformProcessor(subscriber));
    }

    private class UniOnItemTransformProcessor
    extends UniOperatorProcessor<I, O> {
        public UniOnItemTransformProcessor(UniSubscriber<? super O> downstream) {
            super(downstream);
        }

        @Override
        public void onItem(I item) {
            if (!this.isCancelled()) {
                Object outcome;
                try {
                    outcome = UniOnItemTransform.this.mapper.apply(item);
                }
                catch (Throwable e) {
                    this.downstream.onFailure(e);
                    return;
                }
                this.downstream.onItem(outcome);
            }
        }
    }
}

