/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.dialect.function;

import jakarta.persistence.TemporalType;
import java.util.Arrays;
import java.util.List;
import java.util.function.Supplier;
import org.hibernate.dialect.Dialect;
import org.hibernate.metamodel.mapping.BasicValuedMapping;
import org.hibernate.metamodel.mapping.JdbcMappingContainer;
import org.hibernate.metamodel.mapping.MappingModelExpressible;
import org.hibernate.query.ReturnableType;
import org.hibernate.query.sqm.TemporalUnit;
import org.hibernate.query.sqm.function.AbstractSqmSelfRenderingFunctionDescriptor;
import org.hibernate.query.sqm.function.SelfRenderingFunctionSqlAstExpression;
import org.hibernate.query.sqm.produce.function.ArgumentTypesValidator;
import org.hibernate.query.sqm.produce.function.FunctionParameterType;
import org.hibernate.query.sqm.produce.function.FunctionReturnTypeResolver;
import org.hibernate.query.sqm.produce.function.StandardArgumentsValidators;
import org.hibernate.query.sqm.produce.function.StandardFunctionArgumentTypeResolvers;
import org.hibernate.query.sqm.produce.function.StandardFunctionReturnTypeResolvers;
import org.hibernate.query.sqm.produce.function.internal.PatternRenderer;
import org.hibernate.query.sqm.tree.SqmTypedNode;
import org.hibernate.query.sqm.tree.expression.SqmDurationUnit;
import org.hibernate.sql.ast.SqlAstTranslator;
import org.hibernate.sql.ast.spi.SqlAppender;
import org.hibernate.sql.ast.tree.SqlAstNode;
import org.hibernate.sql.ast.tree.expression.DurationUnit;
import org.hibernate.sql.ast.tree.expression.Expression;
import org.hibernate.type.BasicType;
import org.hibernate.type.StandardBasicTypes;
import org.hibernate.type.spi.TypeConfiguration;

public class TimestampdiffFunction
extends AbstractSqmSelfRenderingFunctionDescriptor {
    private final Dialect dialect;

    public TimestampdiffFunction(Dialect dialect, TypeConfiguration typeConfiguration) {
        super("timestampdiff", new ArgumentTypesValidator(StandardArgumentsValidators.exactly(3), FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL, FunctionParameterType.TEMPORAL), new TimestampdiffFunctionReturnTypeResolver(typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.LONG), typeConfiguration.getBasicTypeRegistry().resolve(StandardBasicTypes.DOUBLE)), StandardFunctionArgumentTypeResolvers.invariant(typeConfiguration, FunctionParameterType.TEMPORAL_UNIT, FunctionParameterType.TEMPORAL, FunctionParameterType.TEMPORAL));
        this.dialect = dialect;
    }

    @Override
    public void render(SqlAppender sqlAppender, List<? extends SqlAstNode> arguments, ReturnableType<?> returnType, SqlAstTranslator<?> walker) {
        DurationUnit field = (DurationUnit)arguments.get(0);
        Expression from = (Expression)arguments.get(1);
        Expression to = (Expression)arguments.get(2);
        this.patternRenderer(field == null ? null : field.getUnit(), from, to).render(sqlAppender, arguments, walker);
    }

    private PatternRenderer patternRenderer(TemporalUnit unit, Expression from, Expression to) {
        TemporalType lhsTemporalType = TypeConfiguration.getSqlTemporalType(from.getExpressionType());
        TemporalType rhsTemporalType = TypeConfiguration.getSqlTemporalType(to.getExpressionType());
        return new PatternRenderer(this.dialect.timestampdiffPattern(unit, lhsTemporalType, rhsTemporalType));
    }

    public SelfRenderingFunctionSqlAstExpression expression(ReturnableType<?> impliedResultType, SqlAstNode ... sqlAstArguments) {
        DurationUnit field = (DurationUnit)sqlAstArguments[0];
        return new SelfRenderingFunctionSqlAstExpression(this.getName(), this, Arrays.asList(sqlAstArguments), impliedResultType != null ? impliedResultType : (ReturnableType)((Object)field.getExpressionType().getJdbcMapping()), field != null ? field.getExpressionType() : (JdbcMappingContainer)((Object)impliedResultType));
    }

    @Override
    public String getArgumentListSignature() {
        return "(TEMPORAL_UNIT field, TEMPORAL start, TEMPORAL end)";
    }

    private static class TimestampdiffFunctionReturnTypeResolver
    implements FunctionReturnTypeResolver {
        private final BasicType<Long> longType;
        private final BasicType<Double> doubleType;

        public TimestampdiffFunctionReturnTypeResolver(BasicType<Long> longType, BasicType<Double> doubleType) {
            this.longType = longType;
            this.doubleType = doubleType;
        }

        @Override
        public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
            return this.resolveFunctionReturnType(impliedType, null, arguments, typeConfiguration);
        }

        @Override
        public ReturnableType<?> resolveFunctionReturnType(ReturnableType<?> impliedType, Supplier<MappingModelExpressible<?>> inferredTypeSupplier, List<? extends SqmTypedNode<?>> arguments, TypeConfiguration typeConfiguration) {
            BasicType<Number> invariantType = ((SqmDurationUnit)arguments.get(0)).getUnit() == TemporalUnit.SECOND ? this.doubleType : this.longType;
            return StandardFunctionReturnTypeResolvers.isAssignableTo(invariantType, impliedType) ? impliedType : invariantType;
        }

        @Override
        public BasicValuedMapping resolveFunctionReturnType(Supplier<BasicValuedMapping> impliedTypeAccess, List<? extends SqlAstNode> arguments) {
            BasicType<Number> invariantType = ((SqmDurationUnit)((Object)arguments.get(0))).getUnit() == TemporalUnit.SECOND ? this.doubleType : this.longType;
            return StandardFunctionReturnTypeResolvers.useImpliedTypeIfPossible(invariantType, impliedTypeAccess.get());
        }

        @Override
        public String getReturnType() {
            return this.longType + "|" + this.doubleType;
        }
    }
}

