/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.admin.ui.rest;

import jakarta.ws.rs.Consumes;
import jakarta.ws.rs.InternalServerErrorException;
import jakarta.ws.rs.PUT;
import jakarta.ws.rs.core.Response;
import org.eclipse.microprofile.openapi.annotations.Operation;
import org.keycloak.admin.ui.rest.model.UIRealmRepresentation;
import org.keycloak.models.KeycloakSession;
import org.keycloak.representations.idm.RealmRepresentation;
import org.keycloak.representations.userprofile.config.UPConfig;
import org.keycloak.services.resources.admin.AdminEventBuilder;
import org.keycloak.services.resources.admin.RealmAdminResource;
import org.keycloak.services.resources.admin.UserProfileResource;
import org.keycloak.services.resources.admin.permissions.AdminPermissionEvaluator;

public class UIRealmResource {
    private final RealmAdminResource delegate;
    private final KeycloakSession session;
    private final AdminPermissionEvaluator auth;
    private final AdminEventBuilder adminEvent;

    public UIRealmResource(KeycloakSession session, AdminPermissionEvaluator auth, AdminEventBuilder adminEvent) {
        this.session = session;
        this.auth = auth;
        this.adminEvent = adminEvent;
        this.delegate = new RealmAdminResource(session, auth, adminEvent);
    }

    @PUT
    @Consumes(value={"application/json"})
    @Operation(hidden=true)
    public Response updateRealm(UIRealmRepresentation rep) {
        Response response = this.delegate.updateRealm((RealmRepresentation)rep);
        if (this.isSuccessful(response)) {
            this.updateUserProfileConfiguration(rep);
        }
        return response;
    }

    private void updateUserProfileConfiguration(UIRealmRepresentation rep) {
        UPConfig upConfig = rep.getUpConfig();
        if (upConfig == null) {
            return;
        }
        UserProfileResource userProfileResource = new UserProfileResource(this.session, this.auth, this.adminEvent);
        if (!upConfig.equals((Object)userProfileResource.getConfiguration())) {
            Response response = userProfileResource.update(upConfig);
            if (this.isSuccessful(response)) {
                return;
            }
            throw new InternalServerErrorException("Failed to update user profile configuration");
        }
    }

    private boolean isSuccessful(Response response) {
        return Response.Status.Family.SUCCESSFUL.equals((Object)response.getStatusInfo().getFamily());
    }
}

