/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.model;

import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.model.ExtensionCapabilities;
import io.quarkus.bootstrap.model.PlatformImports;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class DefaultApplicationModel
implements ApplicationModel,
Serializable {
    private static final long serialVersionUID = -3878782344578748234L;
    private final ResolvedDependency appArtifact;
    private final List<ResolvedDependency> dependencies;
    private final PlatformImports platformImports;
    private final List<ExtensionCapabilities> capabilityContracts;
    private final Set<ArtifactKey> localProjectArtifacts;
    private final Map<ArtifactKey, Set<String>> excludedResources;

    public DefaultApplicationModel(ApplicationModelBuilder builder) {
        this.appArtifact = builder.appArtifact;
        this.dependencies = builder.buildDependencies();
        this.platformImports = builder.platformImports;
        this.capabilityContracts = builder.extensionCapabilities;
        this.localProjectArtifacts = builder.reloadableWorkspaceModules;
        this.excludedResources = builder.excludedResources;
    }

    @Override
    public ResolvedDependency getAppArtifact() {
        return this.appArtifact;
    }

    @Override
    public Collection<ResolvedDependency> getDependencies() {
        return this.collectDependencies(8);
    }

    @Override
    public Collection<ResolvedDependency> getRuntimeDependencies() {
        return this.collectDependencies(4);
    }

    @Override
    public Iterable<ResolvedDependency> getDependencies(int flags) {
        return new FlagDependencyIterator(new int[]{flags});
    }

    @Override
    public Iterable<ResolvedDependency> getDependenciesWithAnyFlag(int ... flags) {
        return new FlagDependencyIterator(flags);
    }

    @Override
    public PlatformImports getPlatforms() {
        return this.platformImports;
    }

    @Override
    public Collection<ExtensionCapabilities> getExtensionCapabilities() {
        return this.capabilityContracts;
    }

    @Override
    public Set<ArtifactKey> getParentFirst() {
        return this.collectKeys(264);
    }

    @Override
    public Set<ArtifactKey> getRunnerParentFirst() {
        return this.collectKeys(520);
    }

    @Override
    public Set<ArtifactKey> getLowerPriorityArtifacts() {
        return this.collectKeys(1032);
    }

    @Override
    public Set<ArtifactKey> getReloadableWorkspaceDependencies() {
        return this.localProjectArtifacts;
    }

    @Override
    public Map<ArtifactKey, Set<String>> getRemovedResources() {
        return this.excludedResources;
    }

    private Collection<ResolvedDependency> collectDependencies(int flags) {
        ArrayList<ResolvedDependency> result = new ArrayList<ResolvedDependency>();
        for (ResolvedDependency d : this.getDependencies(flags)) {
            result.add(d);
        }
        return result;
    }

    private Set<ArtifactKey> collectKeys(int flags) {
        HashSet<ArtifactKey> keys = new HashSet<ArtifactKey>();
        for (ResolvedDependency d : this.getDependencies(flags)) {
            keys.add(d.getKey());
        }
        return keys;
    }

    private class FlagDependencyIterator
    implements Iterable<ResolvedDependency> {
        private final int[] flags;

        private FlagDependencyIterator(int[] flags) {
            this.flags = flags;
        }

        @Override
        public Iterator<ResolvedDependency> iterator() {
            return new Iterator<ResolvedDependency>(){
                final Iterator<ResolvedDependency> i;
                ResolvedDependency next;
                {
                    this.i = DefaultApplicationModel.this.dependencies.iterator();
                    this.moveOn();
                }

                @Override
                public boolean hasNext() {
                    return this.next != null;
                }

                @Override
                public ResolvedDependency next() {
                    if (this.next == null) {
                        throw new NoSuchElementException();
                    }
                    ResolvedDependency current = this.next;
                    this.moveOn();
                    return current;
                }

                private void moveOn() {
                    this.next = null;
                    while (this.i.hasNext()) {
                        ResolvedDependency d = this.i.next();
                        if (!d.hasAnyFlag(FlagDependencyIterator.this.flags)) continue;
                        this.next = d;
                        break;
                    }
                }
            };
        }
    }
}

