/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.legacy.infinispan;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.net.ssl.SSLContext;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.metrics.config.MicrometerMeterRegisterConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.ExhaustedAction;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.jboss.logging.Logger;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.TCP_NIO2;
import org.jgroups.protocols.UDP;
import org.jgroups.util.TLS;
import org.jgroups.util.TLSClientAuth;
import org.keycloak.common.Profile;
import org.keycloak.config.CachingOptions;
import org.keycloak.config.MetricsOptions;
import org.keycloak.config.Option;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.quarkus.runtime.configuration.Configuration;

public class CacheManagerFactory {
    private static final Logger logger = Logger.getLogger(CacheManagerFactory.class);
    private final CompletableFuture<DefaultCacheManager> cacheManagerFuture;

    public CacheManagerFactory(String config) {
        this.cacheManagerFuture = this.startEmbeddedCacheManager(config);
    }

    public DefaultCacheManager getOrCreateEmbeddedCacheManager() {
        return CacheManagerFactory.join(this.cacheManagerFuture);
    }

    public void shutdown() {
        logger.debug((Object)"Shutdown embedded cache manager");
        this.cacheManagerFuture.thenAccept(CacheManagerFactory::close);
    }

    private static <T> T join(Future<T> future) {
        try {
            return future.get(CacheManagerFactory.getStartTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException("Failed to start embedded or remote cache manager", e);
        }
    }

    private static void close(Lifecycle lifecycle) {
        if (lifecycle != null) {
            lifecycle.stop();
        }
    }

    private CompletableFuture<DefaultCacheManager> startEmbeddedCacheManager(String config) {
        ConfigurationBuilderHolder builder = new ParserRegistry().parse(config);
        if (builder.getNamedConfigurationBuilders().entrySet().stream().anyMatch(c -> ((ConfigurationBuilder)c.getValue()).clustering().cacheMode().isClustered())) {
            this.configureTransportStack(builder);
            this.configureRemoteStores(builder);
        }
        InfinispanConnectionProvider.DISTRIBUTED_REPLICATED_CACHE_NAMES.forEach(cacheName -> {
            if (cacheName.equals("sessions") || cacheName.equals("clientSessions") || cacheName.equals("offlineSessions") || cacheName.equals("offlineClientSessions")) {
                ConfigurationBuilder configurationBuilder = (ConfigurationBuilder)builder.getNamedConfigurationBuilders().get(cacheName);
                if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.PERSISTENT_USER_SESSIONS)) {
                    if (configurationBuilder.memory().maxCount() == -1L) {
                        logger.infof("Persistent user sessions enabled and no memory limit found in configuration. Setting max entries for %s to 10000 entries.", cacheName);
                        configurationBuilder.memory().maxCount(10000L);
                    }
                    configurationBuilder.clustering().hash().numOwners(1);
                } else {
                    if (configurationBuilder.memory().maxCount() != -1L) {
                        logger.warnf("Persistent user sessions NOT enabled and memory limit found in configuration for cache %s. This might be a misconfiguration!", cacheName);
                    }
                    if ((Integer)configurationBuilder.clustering().hash().attributes().attribute(HashConfiguration.NUM_OWNERS).get() == 1 && configurationBuilder.persistence().stores().isEmpty()) {
                        logger.warnf("Number of owners is one for cache %s, and no persistence is configured. This might be a misconfiguration as you will lose data when a single node is restarted!", cacheName);
                    }
                }
            }
        });
        if (Configuration.isTrue((Option<Boolean>)MetricsOptions.METRICS_ENABLED)) {
            builder.getGlobalConfigurationBuilder().addModule(MicrometerMeterRegisterConfigurationBuilder.class);
            ((MicrometerMeterRegisterConfigurationBuilder)builder.getGlobalConfigurationBuilder().module(MicrometerMeterRegisterConfigurationBuilder.class)).meterRegistry((MeterRegistry)Metrics.globalRegistry);
            builder.getGlobalConfigurationBuilder().cacheContainer().statistics(true);
            builder.getGlobalConfigurationBuilder().metrics().namesAsTags(true);
            if (Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_METRICS_HISTOGRAMS_ENABLED)) {
                builder.getGlobalConfigurationBuilder().metrics().histograms(true);
            }
            builder.getNamedConfigurationBuilders().forEach((s, configurationBuilder) -> configurationBuilder.statistics().enabled(true));
        }
        Marshalling.configure((GlobalConfigurationBuilder)builder.getGlobalConfigurationBuilder());
        boolean start = CacheManagerFactory.isStartEagerly();
        return CompletableFuture.supplyAsync(() -> new DefaultCacheManager(builder, start));
    }

    private static boolean isRemoteTLSEnabled() {
        return Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_REMOTE_TLS_ENABLED);
    }

    private static boolean isRemoteAuthenticationEnabled() {
        return Configuration.getOptionalKcValue("cache-remote-username").isPresent() || Configuration.getOptionalKcValue("cache-remote-password").isPresent();
    }

    private static SSLContext createSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStartEagerly() {
        return Boolean.parseBoolean(System.getProperty("kc.cache-ispn-start-eagerly", Boolean.TRUE.toString()));
    }

    private static int getStartTimeout() {
        return Integer.getInteger("kc.cache-ispn-start-timeout", 120);
    }

    private void configureTransportStack(ConfigurationBuilderHolder builder) {
        String transportStack = Configuration.getRawValue("kc.cache-stack");
        TransportConfigurationBuilder transportConfig = builder.getGlobalConfigurationBuilder().transport();
        if (transportStack != null && !transportStack.isBlank()) {
            transportConfig.defaultTransport().stack(transportStack);
        }
        if (Configuration.isTrue("cache-embedded-mtls-enabled")) {
            this.validateTlsAvailable(transportConfig.build());
            TLS tls = new TLS().enabled(true).setKeystorePath(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-key-store-file")).setKeystorePassword(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-key-store-password")).setKeystoreType("pkcs12").setTruststorePath(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-trust-store-file")).setTruststorePassword(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-trust-store-password")).setTruststoreType("pkcs12").setClientAuth(TLSClientAuth.NEED).setProtocols(new String[]{"TLSv1.3"});
            transportConfig.addProperty("socketFactory", (Object)tls.createSocketFactory());
            Logger.getLogger(CacheManagerFactory.class).info((Object)"MTLS enabled for communications for embedded caches");
        }
    }

    private void validateTlsAvailable(GlobalConfiguration config) {
        String stackName = config.transport().stack();
        if (stackName == null) {
            return;
        }
        for (ProtocolConfiguration protocol : config.transport().jgroups().configurator(stackName).getProtocolStack()) {
            String name = protocol.getProtocolName();
            if (!name.equals(UDP.class.getSimpleName()) && !name.equals(UDP.class.getName()) && !name.equals(TCP_NIO2.class.getSimpleName()) && !name.equals(TCP_NIO2.class.getName())) continue;
            throw new RuntimeException("Cache TLS is not available with protocol " + name);
        }
    }

    private void configureRemoteStores(ConfigurationBuilderHolder builder) {
        if (Configuration.getOptionalKcValue("cache-remote-host").isPresent()) {
            String cacheRemoteHost = CacheManagerFactory.requiredStringProperty("cache-remote-host");
            Integer cacheRemotePort = Configuration.getOptionalKcValue("cache-remote-port").map(Integer::parseInt).orElse(11222);
            SSLContext sslContext = CacheManagerFactory.createSSLContext();
            InfinispanConnectionProvider.DISTRIBUTED_REPLICATED_CACHE_NAMES.forEach(cacheName -> {
                PersistenceConfigurationBuilder persistenceCB = ((ConfigurationBuilder)builder.getNamedConfigurationBuilders().get(cacheName)).persistence();
                if (!persistenceCB.stores().isEmpty()) {
                    throw new RuntimeException(String.format("Remote store for cache '%s' is already configured via CLI parameters. It should not be present in the XML file.", cacheName));
                }
                RemoteStoreConfigurationBuilder storeBuilder = (RemoteStoreConfigurationBuilder)persistenceCB.addStore(RemoteStoreConfigurationBuilder.class);
                ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)storeBuilder.rawValues(true).shared(true)).segmented(false)).remoteCacheName(cacheName).connectionPool().maxActive(16).exhaustedAction(ExhaustedAction.CREATE_NEW).addServer().host(cacheRemoteHost).port(cacheRemotePort.intValue());
                if (CacheManagerFactory.isRemoteTLSEnabled()) {
                    storeBuilder.remoteSecurity().ssl().enable().sslContext(sslContext).sniHostName(cacheRemoteHost);
                }
                if (CacheManagerFactory.isRemoteAuthenticationEnabled()) {
                    storeBuilder.remoteSecurity().authentication().enable().username(CacheManagerFactory.requiredStringProperty("cache-remote-username")).password(CacheManagerFactory.requiredStringProperty("cache-remote-password")).realm("default").saslMechanism("SCRAM-SHA-512");
                }
            });
        }
    }

    private static String requiredStringProperty(String propertyName) {
        return Configuration.getOptionalKcValue(propertyName).orElseThrow(() -> new RuntimeException("Property " + propertyName + " required but not specified"));
    }
}

