/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.cache.infinispan.authorization.events;

import java.util.Objects;
import org.infinispan.protostream.annotations.ProtoField;
import org.keycloak.models.cache.infinispan.authorization.events.AuthorizationCacheInvalidationEvent;
import org.keycloak.models.cache.infinispan.events.InvalidationEvent;

abstract class BasePermissionTicketEvent
extends InvalidationEvent
implements AuthorizationCacheInvalidationEvent {
    private final String owner;
    private final String resource;
    private final String scope;
    private final String serverId;
    private final String requester;
    private final String resourceName;

    BasePermissionTicketEvent(String id, String owner, String resource, String scope, String serverId, String requester, String resourceName) {
        super(id);
        this.owner = owner;
        this.resource = resource;
        this.scope = scope;
        this.serverId = serverId;
        this.requester = requester;
        this.resourceName = resourceName;
    }

    @ProtoField(value=2)
    public String getOwner() {
        return this.owner;
    }

    @ProtoField(value=3)
    public String getRequester() {
        return this.requester;
    }

    @ProtoField(value=4)
    public String getResource() {
        return this.resource;
    }

    @ProtoField(value=5)
    public String getResourceName() {
        return this.resourceName;
    }

    @ProtoField(value=6)
    public String getScope() {
        return this.scope;
    }

    @ProtoField(value=7)
    public String getServerId() {
        return this.serverId;
    }

    public String toString() {
        return "%s [ id=%s, name=%s]".formatted(this.getClass().getName(), this.getId(), this.resource);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        BasePermissionTicketEvent that = (BasePermissionTicketEvent)o;
        return Objects.equals(this.resource, that.resource) && Objects.equals(this.serverId, that.serverId);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.resource, this.serverId);
    }
}

