/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.authorization.policy.provider;

import jakarta.persistence.criteria.CriteriaBuilder;
import jakarta.persistence.criteria.CriteriaQuery;
import jakarta.persistence.criteria.Path;
import java.util.Set;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.keycloak.authorization.policy.provider.PartialEvaluationStorageProvider;
import org.keycloak.representations.idm.authorization.ResourceType;

public class PartialEvaluationContext {
    private final ResourceType resourceType;
    private CriteriaQuery<?> criteriaQuery;
    private Path<?> path;
    private PartialEvaluationStorageProvider storage;
    private CriteriaBuilder criteriaBuilder;
    private final Set<String> allowedResources;
    private final Set<String> deniedResources;
    private Set<String> allowedGroups = Set.of();
    private Set<String> deniedGroups = Set.of();

    public PartialEvaluationContext(PartialEvaluationStorageProvider storage, CriteriaBuilder criteriaBuilder, CriteriaQuery<?> criteriaQuery, Path<?> path) {
        this(null, Set.of(), Set.of(), storage, criteriaBuilder, criteriaQuery, path);
    }

    public PartialEvaluationContext(ResourceType resourceType, Set<String> allowedResources, Set<String> deniedResources, PartialEvaluationStorageProvider storage, CriteriaBuilder criteriaBuilder, CriteriaQuery<?> criteriaQuery, Path<?> path) {
        this.allowedResources = allowedResources;
        this.deniedResources = deniedResources;
        this.storage = storage;
        this.criteriaBuilder = criteriaBuilder;
        this.criteriaQuery = criteriaQuery;
        this.path = path;
        this.resourceType = resourceType;
    }

    public boolean isResourceTypeAllowed() {
        return this.allowedResources.contains(this.resourceType.getType());
    }

    public Set<String> getAllowedResourceIds() {
        return this.allowedResources.stream().filter(Predicate.not(this.resourceType.getType()::equals)).collect(Collectors.toSet());
    }

    public Set<String> getDeniedGroupIds() {
        return this.deniedGroups.stream().filter(Predicate.not(this.resourceType.getGroupType()::equals)).collect(Collectors.toSet());
    }

    public void setAllowedGroups(Set<String> allowedGroups) {
        this.allowedGroups = allowedGroups;
    }

    public void setDeniedGroups(Set<String> deniedGroups) {
        this.deniedGroups = deniedGroups;
    }

    public Set<String> getDeniedGroups() {
        return this.deniedGroups;
    }

    public Set<String> getAllowedGroups() {
        return this.allowedGroups;
    }

    public Set<String> getAllowedResources() {
        return this.allowedResources;
    }

    public Path<?> getPath() {
        return this.path;
    }

    public Set<String> deniedResources() {
        return this.deniedResources;
    }

    public CriteriaQuery<?> criteriaQuery() {
        return this.criteriaQuery;
    }

    public CriteriaBuilder getCriteriaBuilder() {
        return this.criteriaBuilder;
    }

    public ResourceType getResourceType() {
        return this.resourceType;
    }

    public PartialEvaluationStorageProvider getStorage() {
        return this.storage;
    }

    public Set<String> getDeniedResources() {
        return this.deniedResources;
    }

    public void setStorage(PartialEvaluationStorageProvider storage) {
        this.storage = storage;
    }

    public void setCriteriaBuilder(CriteriaBuilder criteriaBuilder) {
        this.criteriaBuilder = criteriaBuilder;
    }

    public void setCriteriaQuery(CriteriaQuery<?> criteriaQuery) {
        this.criteriaQuery = criteriaQuery;
    }

    public void setPath(Path<?> path) {
        this.path = path;
    }
}

