/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.config;

import com.google.common.base.CaseFormat;
import java.io.File;
import org.keycloak.config.Option;
import org.keycloak.config.OptionBuilder;
import org.keycloak.config.OptionCategory;

public class CachingOptions {
    public static final String CACHE_CONFIG_FILE_PROPERTY = "cache-config-file";
    private static final String CACHE_EMBEDDED_PREFIX = "cache-embedded";
    private static final String CACHE_EMBEDDED_MTLS_PREFIX = "cache-embedded-mtls";
    public static final String CACHE_EMBEDDED_MTLS_ENABLED_PROPERTY = "cache-embedded-mtls-enabled";
    public static final String CACHE_EMBEDDED_MTLS_KEYSTORE_FILE_PROPERTY = "cache-embedded-mtls-key-store-file";
    public static final String CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD_PROPERTY = "cache-embedded-mtls-key-store-password";
    public static final String CACHE_EMBEDDED_MTLS_TRUSTSTORE_FILE_PROPERTY = "cache-embedded-mtls-trust-store-file";
    public static final String CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD_PROPERTY = "cache-embedded-mtls-trust-store-password";
    public static final String CACHE_EMBEDDED_MTLS_ROTATION_PROPERTY = "cache-embedded-mtls-rotation-interval-days";
    private static final String CACHE_REMOTE_PREFIX = "cache-remote";
    public static final String CACHE_REMOTE_HOST_PROPERTY = "cache-remote-host";
    public static final String CACHE_REMOTE_PORT_PROPERTY = "cache-remote-port";
    public static final String CACHE_REMOTE_USERNAME_PROPERTY = "cache-remote-username";
    public static final String CACHE_REMOTE_PASSWORD_PROPERTY = "cache-remote-password";
    public static final String CACHE_REMOTE_TLS_ENABLED_PROPERTY = "cache-remote-tls-enabled";
    private static final String CACHE_METRICS_PREFIX = "cache-metrics";
    public static final String CACHE_METRICS_HISTOGRAMS_ENABLED_PROPERTY = "cache-metrics-histograms-enabled";
    public static final String[] LOCAL_MAX_COUNT_CACHES = new String[]{"authorization", "crl", "keys", "realms", "users"};
    public static final String[] CLUSTERED_MAX_COUNT_CACHES = new String[]{"clientSessions", "offlineSessions", "offlineClientSessions", "sessions"};
    public static final Option<Mechanism> CACHE = new OptionBuilder<Mechanism>("cache", Mechanism.class).category(OptionCategory.CACHE).description("Defines the cache mechanism for high-availability. By default in production mode, a 'ispn' cache is used to create a cluster between multiple server nodes. By default in development mode, a 'local' cache disables clustering and is intended for development and testing purposes.").defaultValue(Mechanism.ispn).build();
    public static final Option<Stack> CACHE_STACK = new OptionBuilder<Stack>("cache-stack", Stack.class).category(OptionCategory.CACHE).strictExpectedValues(false).description("Define the default stack to use for cluster communication and node discovery.").defaultValue(Stack.jdbc_ping).deprecatedValues("Use 'jdbc-ping' instead", (Stack[])new Stack[]{Stack.azure, Stack.ec2, Stack.google, Stack.tcp, Stack.udp, Stack.jdbc_ping_udp}).build();
    public static final Option<File> CACHE_CONFIG_FILE = new OptionBuilder<File>("cache-config-file", File.class).category(OptionCategory.CACHE).description("Defines the file from which cache configuration should be loaded from. The configuration file is relative to the 'conf/' directory.").build();
    public static final Option<Boolean> CACHE_EMBEDDED_MTLS_ENABLED = new OptionBuilder<Boolean>("cache-embedded-mtls-enabled", Boolean.class).category(OptionCategory.CACHE).description("Encrypts the network communication between Keycloak servers. If no additional parameters about a keystore and truststore are provided, ephemeral key pairs and certificates are created and rotated automatically, which is recommended for standard setups.").defaultValue(Boolean.TRUE).build();
    public static final Option<String> CACHE_EMBEDDED_MTLS_KEYSTORE = new OptionBuilder<String>("cache-embedded-mtls-key-store-file", String.class).category(OptionCategory.CACHE).description("The Keystore file path. The Keystore must contain the certificate to use by the TLS protocol. By default, it looks up 'cache-mtls-keystore.p12' under conf/ directory.").build();
    public static final Option<String> CACHE_EMBEDDED_MTLS_KEYSTORE_PASSWORD = new OptionBuilder<String>("cache-embedded-mtls-key-store-password", String.class).category(OptionCategory.CACHE).description("The password to access the Keystore.").build();
    public static final Option<String> CACHE_EMBEDDED_MTLS_TRUSTSTORE = new OptionBuilder<String>("cache-embedded-mtls-trust-store-file", String.class).category(OptionCategory.CACHE).description("The Truststore file path. It should contain the trusted certificates or the Certificate Authority that signed the certificates. By default, it lookup 'cache-mtls-truststore.p12' under conf/ directory.").build();
    public static final Option<String> CACHE_EMBEDDED_MTLS_TRUSTSTORE_PASSWORD = new OptionBuilder<String>("cache-embedded-mtls-trust-store-password", String.class).category(OptionCategory.CACHE).description("The password to access the Truststore.").build();
    public static final Option<Integer> CACHE_EMBEDDED_MTLS_ROTATION = new OptionBuilder<Integer>("cache-embedded-mtls-rotation-interval-days", Integer.class).category(OptionCategory.CACHE).defaultValue(30).description("Rotation period in days of automatic JGroups MTLS certificates.").build();
    public static final Option<String> CACHE_REMOTE_HOST = new OptionBuilder<String>("cache-remote-host", String.class).category(OptionCategory.CACHE).description("The hostname of the external Infinispan cluster.").build();
    public static final Option<Integer> CACHE_REMOTE_PORT = new OptionBuilder<Integer>("cache-remote-port", Integer.class).category(OptionCategory.CACHE).description("The port of the external Infinispan cluster.").defaultValue(11222).build();
    public static final Option<String> CACHE_REMOTE_USERNAME = new OptionBuilder<String>("cache-remote-username", String.class).category(OptionCategory.CACHE).description(String.format("The username for the authentication to the external Infinispan cluster. It is optional if connecting to an unsecure external Infinispan cluster. If the option is specified, '%s' is required as well.", "cache-remote-password")).build();
    public static final Option<String> CACHE_REMOTE_PASSWORD = new OptionBuilder<String>("cache-remote-password", String.class).category(OptionCategory.CACHE).description(String.format("The password for the authentication to the external Infinispan cluster. It is optional if connecting to an unsecure external Infinispan cluster. If the option is specified, '%s' is required as well.", "cache-remote-username")).build();
    public static final Option<Boolean> CACHE_METRICS_HISTOGRAMS_ENABLED = new OptionBuilder<Boolean>("cache-metrics-histograms-enabled", Boolean.class).category(OptionCategory.CACHE).description("Enable histograms for metrics for the embedded caches.").build();
    public static final Option<Boolean> CACHE_REMOTE_TLS_ENABLED = new OptionBuilder<Boolean>("cache-remote-tls-enabled", Boolean.class).category(OptionCategory.CACHE).description("Enable TLS support to communicate with a secured remote Infinispan server. Recommended to be enabled in production.").defaultValue(Boolean.TRUE).build();

    public static Option<Integer> maxCountOption(String cache) {
        return new OptionBuilder<Integer>(CachingOptions.cacheMaxCountProperty(cache), Integer.class).category(OptionCategory.CACHE).description(String.format("The maximum number of entries that can be stored in-memory by the %s cache.", cache)).build();
    }

    public static String cacheMaxCountProperty(String cacheName) {
        cacheName = CaseFormat.LOWER_CAMEL.to(CaseFormat.LOWER_HYPHEN, cacheName);
        return String.format("%s-%s-max-count", CACHE_EMBEDDED_PREFIX, cacheName);
    }

    public static enum Mechanism {
        ispn,
        local;

    }

    public static enum Stack {
        jdbc_ping,
        kubernetes,
        jdbc_ping_udp,
        tcp,
        udp,
        ec2,
        azure,
        google;


        public String toString() {
            return CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_HYPHEN, super.toString());
        }
    }
}

