/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.oidc.tokenexchange;

import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriInfo;
import org.keycloak.TokenVerifier;
import org.keycloak.common.ClientConnection;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.ClientModel;
import org.keycloak.models.ImpersonationSessionNote;
import org.keycloak.models.KeycloakSession;
import org.keycloak.models.RealmModel;
import org.keycloak.models.UserModel;
import org.keycloak.models.UserSessionModel;
import org.keycloak.protocol.oidc.TokenExchangeContext;
import org.keycloak.protocol.oidc.tokenexchange.AbstractTokenExchangeProvider;
import org.keycloak.representations.AccessToken;
import org.keycloak.services.CorsErrorResponseException;
import org.keycloak.services.cors.Cors;
import org.keycloak.services.managers.AuthenticationManager;
import org.keycloak.services.managers.UserSessionManager;
import org.keycloak.services.resources.admin.AdminAuth;
import org.keycloak.services.resources.admin.permissions.AdminPermissions;

public class V1TokenExchangeProvider
extends AbstractTokenExchangeProvider {
    public boolean supports(TokenExchangeContext context) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Response tokenExchange() {
        String requestedIssuer;
        KeycloakSession session = this.context.getSession();
        RealmModel realm = this.context.getRealm();
        ClientConnection clientConnection = this.context.getClientConnection();
        Cors cors = this.context.getCors();
        ClientModel client = this.context.getClient();
        EventBuilder event = this.context.getEvent();
        UserModel tokenUser = null;
        UserSessionModel tokenSession = null;
        AccessToken token = null;
        String subjectToken = this.context.getParams().getSubjectToken();
        if (subjectToken != null) {
            String subjectTokenType = this.context.getParams().getSubjectTokenType();
            if (this.isExternalInternalTokenExchangeRequest(this.context)) {
                String subjectIssuer = this.getSubjectIssuer(this.context, subjectToken, subjectTokenType);
                return this.exchangeExternalToken(subjectIssuer, subjectToken);
            }
            if (subjectTokenType != null && !subjectTokenType.equals("urn:ietf:params:oauth:token-type:access_token")) {
                event.detail("reason", "subject_token supports access tokens only");
                event.error("invalid_token");
                throw new CorsErrorResponseException(cors, "invalid_request", "Invalid token type, must be access token", Response.Status.BAD_REQUEST);
            }
            AuthenticationManager.AuthResult authResult = AuthenticationManager.verifyIdentityToken(session, realm, (UriInfo)session.getContext().getUri(), clientConnection, true, true, null, false, subjectToken, this.context.getHeaders(), new TokenVerifier.Predicate[0]);
            if (authResult == null) {
                event.detail("reason", "subject_token validation failure");
                event.error("invalid_token");
                throw new CorsErrorResponseException(cors, "invalid_request", "Invalid token", Response.Status.BAD_REQUEST);
            }
            tokenUser = authResult.getUser();
            tokenSession = authResult.getSession();
            token = authResult.getToken();
        }
        String requestedSubject = (String)this.context.getFormParams().getFirst((Object)"requested_subject");
        boolean disallowOnHolderOfTokenMismatch = true;
        if (requestedSubject != null) {
            event.detail("requested_subject", requestedSubject);
            UserModel requestedUser = session.users().getUserByUsername(realm, requestedSubject);
            if (requestedUser == null) {
                requestedUser = session.users().getUserById(realm, requestedSubject);
            }
            if (requestedUser == null) {
                event.detail("reason", "requested_subject not found");
                event.error("not_allowed");
                throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
            }
            if (token != null) {
                event.detail("impersonator", tokenUser.getUsername());
                AdminAuth auth = new AdminAuth(realm, token, tokenUser, client);
                if (!AdminPermissions.evaluator(session, realm, auth).users().canImpersonate(requestedUser, client)) {
                    event.detail("reason", "subject not allowed to impersonate");
                    event.error("not_allowed");
                    throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
            } else {
                if (client.isPublicClient()) {
                    event.detail("reason", "public clients not allowed");
                    event.error("not_allowed");
                    throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
                if (!AdminPermissions.management(session, realm).users().canClientImpersonate(client, requestedUser)) {
                    event.detail("reason", "client not allowed to impersonate");
                    event.error("not_allowed");
                    throw new CorsErrorResponseException(cors, "access_denied", "Client not allowed to exchange", Response.Status.FORBIDDEN);
                }
                disallowOnHolderOfTokenMismatch = false;
            }
            tokenSession = new UserSessionManager(session).createUserSession(realm, requestedUser, requestedUser.getUsername(), clientConnection.getRemoteHost(), "impersonate", false, null, null);
            if (tokenUser != null) {
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_ID.toString(), tokenUser.getId());
                tokenSession.setNote(ImpersonationSessionNote.IMPERSONATOR_USERNAME.toString(), tokenUser.getUsername());
            }
            tokenUser = requestedUser;
        }
        if ((requestedIssuer = (String)this.context.getFormParams().getFirst((Object)"requested_issuer")) == null) {
            return this.exchangeClientToClient(tokenUser, tokenSession, token, disallowOnHolderOfTokenMismatch);
        }
        try {
            Response response = this.exchangeToIdentityProvider(tokenUser, tokenSession, requestedIssuer);
            return response;
        }
        finally {
            if (subjectToken == null) {
                try {
                    session.sessions().removeUserSession(realm, tokenSession);
                }
                catch (Exception exception) {}
            }
        }
    }
}

