/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.opentelemetry.runtime.metrics.instrumentation;

import io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.instrumentation.runtimemetrics.java17.JfrFeature;
import io.opentelemetry.instrumentation.runtimemetrics.java17.RuntimeMetrics;
import io.quarkus.opentelemetry.runtime.config.runtime.OTelRuntimeConfig;
import io.quarkus.runtime.Startup;
import jakarta.annotation.PreDestroy;
import jakarta.enterprise.context.ApplicationScoped;

@Startup
@ApplicationScoped
public class JvmMetricsService {
    private final RuntimeMetrics runtimeMetrics;

    public JvmMetricsService(OpenTelemetry openTelemetry, OTelRuntimeConfig runtimeConfig) {
        if (runtimeConfig.sdkDisabled() || !runtimeConfig.instrument().jvmMetrics()) {
            this.runtimeMetrics = RuntimeMetrics.builder((OpenTelemetry)openTelemetry).disableAllMetrics().build();
            return;
        }
        this.runtimeMetrics = RuntimeMetrics.builder((OpenTelemetry)openTelemetry).disableFeature(JfrFeature.CONTEXT_SWITCH_METRICS).disableFeature(JfrFeature.CPU_COUNT_METRICS).disableFeature(JfrFeature.LOCK_METRICS).disableFeature(JfrFeature.MEMORY_ALLOCATION_METRICS).disableFeature(JfrFeature.NETWORK_IO_METRICS).enableFeature(JfrFeature.MEMORY_POOL_METRICS).enableFeature(JfrFeature.GC_DURATION_METRICS).enableFeature(JfrFeature.THREAD_METRICS).enableFeature(JfrFeature.CLASS_LOAD_METRICS).enableFeature(JfrFeature.CPU_UTILIZATION_METRICS).build();
    }

    @PreDestroy
    public void close() {
        if (this.runtimeMetrics != null) {
            this.runtimeMetrics.close();
        }
    }
}

