/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.models.sessions.infinispan.changes.remote.updater.loginfailures;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import org.keycloak.models.UserLoginFailureModel;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.BaseUpdater;
import org.keycloak.models.sessions.infinispan.changes.remote.updater.Expiration;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureEntity;
import org.keycloak.models.sessions.infinispan.entities.LoginFailureKey;
import org.keycloak.models.sessions.infinispan.util.SessionTimeouts;

public class LoginFailuresUpdater
extends BaseUpdater<LoginFailureKey, LoginFailureEntity>
implements UserLoginFailureModel {
    private final List<Consumer<LoginFailureEntity>> changes;
    private static final Consumer<LoginFailureEntity> CLEAR = LoginFailureEntity::clearFailures;
    private static final Consumer<LoginFailureEntity> INCREMENT_FAILURES = e -> e.setNumFailures(e.getNumFailures() + 1);
    private static final Consumer<LoginFailureEntity> INCREMENT_LOCK_OUTS = e -> e.setNumTemporaryLockouts(e.getNumTemporaryLockouts() + 1);

    private LoginFailuresUpdater(LoginFailureKey key, LoginFailureEntity entity, long version, BaseUpdater.UpdaterState initialState) {
        super(key, entity, version, initialState);
        if (entity == null) {
            assert (initialState == BaseUpdater.UpdaterState.DELETED);
            this.changes = List.of();
            return;
        }
        this.changes = new ArrayList<Consumer<LoginFailureEntity>>(4);
    }

    public static LoginFailuresUpdater create(LoginFailureKey key, LoginFailureEntity entity) {
        return new LoginFailuresUpdater(key, Objects.requireNonNull(entity), -1L, BaseUpdater.UpdaterState.CREATED);
    }

    public static LoginFailuresUpdater wrap(LoginFailureKey key, LoginFailureEntity value, long version) {
        return new LoginFailuresUpdater(key, Objects.requireNonNull(value), version, BaseUpdater.UpdaterState.READ);
    }

    public static LoginFailuresUpdater delete(LoginFailureKey key) {
        return new LoginFailuresUpdater(key, null, -1L, BaseUpdater.UpdaterState.DELETED);
    }

    @Override
    public Expiration computeExpiration() {
        return new Expiration(SessionTimeouts.getLoginFailuresMaxIdleMs(null, null, (LoginFailureEntity)this.getValue()), SessionTimeouts.getLoginFailuresLifespanMs(null, null, (LoginFailureEntity)this.getValue()));
    }

    @Override
    public LoginFailureEntity apply(LoginFailureKey ignored, LoginFailureEntity cachedEntity) {
        assert (!this.isDeleted());
        assert (!this.isReadOnly());
        if (cachedEntity == null) {
            return null;
        }
        this.changes.forEach(c -> c.accept(cachedEntity));
        return cachedEntity;
    }

    public int getFailedLoginNotBefore() {
        return ((LoginFailureEntity)this.getValue()).getFailedLoginNotBefore();
    }

    public long getLastFailure() {
        return ((LoginFailureEntity)this.getValue()).getLastFailure();
    }

    public String getLastIPFailure() {
        return ((LoginFailureEntity)this.getValue()).getLastIPFailure();
    }

    public int getNumFailures() {
        return ((LoginFailureEntity)this.getValue()).getNumFailures();
    }

    public int getNumTemporaryLockouts() {
        return ((LoginFailureEntity)this.getValue()).getNumTemporaryLockouts();
    }

    public String getUserId() {
        return ((LoginFailureEntity)this.getValue()).getUserId();
    }

    public String getId() {
        return ((LoginFailureKey)this.getKey()).toString();
    }

    public void clearFailures() {
        this.changes.clear();
        this.addAndApplyChange(CLEAR);
    }

    public void setFailedLoginNotBefore(int notBefore) {
        this.addAndApplyChange(e -> e.setFailedLoginNotBefore(notBefore));
    }

    public void incrementFailures() {
        this.addAndApplyChange(INCREMENT_FAILURES);
    }

    public void incrementTemporaryLockouts() {
        this.addAndApplyChange(INCREMENT_LOCK_OUTS);
    }

    public void setLastFailure(long lastFailure) {
        this.addAndApplyChange(e -> e.setLastFailure(lastFailure));
    }

    public void setLastIPFailure(String ip) {
        this.addAndApplyChange(e -> e.setLastIPFailure(ip));
    }

    @Override
    protected boolean isUnchanged() {
        return this.changes.isEmpty();
    }

    private void addAndApplyChange(Consumer<LoginFailureEntity> change) {
        this.changes.add(change);
        change.accept((LoginFailureEntity)this.getValue());
    }
}

