/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.query.sqm.tree;

import jakarta.persistence.criteria.AbstractQuery;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.hibernate.query.criteria.JpaCteCriteria;
import org.hibernate.query.criteria.JpaRoot;
import org.hibernate.query.sqm.NodeBuilder;
import org.hibernate.query.sqm.SqmQuerySource;
import org.hibernate.query.sqm.spi.SqmCreationHelper;
import org.hibernate.query.sqm.tree.AbstractSqmStatement;
import org.hibernate.query.sqm.tree.SqmCopyContext;
import org.hibernate.query.sqm.tree.SqmDmlStatement;
import org.hibernate.query.sqm.tree.cte.SqmCteContainer;
import org.hibernate.query.sqm.tree.cte.SqmCteStatement;
import org.hibernate.query.sqm.tree.expression.SqmParameter;
import org.hibernate.query.sqm.tree.from.SqmRoot;
import org.hibernate.query.sqm.tree.select.SqmSelectQuery;
import org.hibernate.query.sqm.tree.select.SqmSubQuery;

public abstract class AbstractSqmDmlStatement<E>
extends AbstractSqmStatement<E>
implements SqmDmlStatement<E> {
    private final Map<String, SqmCteStatement<?>> cteStatements;
    private SqmRoot<E> target;

    public AbstractSqmDmlStatement(SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        super(querySource, nodeBuilder);
        this.cteStatements = new LinkedHashMap();
    }

    public AbstractSqmDmlStatement(SqmRoot<E> target, SqmQuerySource querySource, NodeBuilder nodeBuilder) {
        this(querySource, nodeBuilder);
        this.target = target;
    }

    public AbstractSqmDmlStatement(NodeBuilder builder, SqmQuerySource querySource, Set<SqmParameter<?>> parameters, Map<String, SqmCteStatement<?>> cteStatements, SqmRoot<E> target) {
        super(builder, querySource, parameters);
        this.cteStatements = cteStatements;
        this.target = target;
    }

    protected Map<String, SqmCteStatement<?>> copyCteStatements(SqmCopyContext context) {
        LinkedHashMap cteStatements = new LinkedHashMap(this.cteStatements.size());
        for (Map.Entry<String, SqmCteStatement<?>> entry : this.cteStatements.entrySet()) {
            cteStatements.put(entry.getKey(), (SqmCteStatement<?>)entry.getValue().copy(context));
        }
        return cteStatements;
    }

    protected void putAllCtes(SqmCteContainer cteContainer) {
        for (SqmCteStatement<?> cteStatement : cteContainer.getCteStatements()) {
            if (this.cteStatements.putIfAbsent(cteStatement.getName(), cteStatement) == null) continue;
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists");
        }
    }

    public abstract void validate(@Nullable String var1);

    @Override
    public Collection<SqmCteStatement<?>> getCteStatements() {
        return this.cteStatements.values();
    }

    @Override
    public SqmCteStatement<?> getCteStatement(String cteLabel) {
        return this.cteStatements.get(cteLabel);
    }

    @Override
    public Collection<? extends JpaCteCriteria<?>> getCteCriterias() {
        return this.cteStatements.values();
    }

    public <X> JpaCteCriteria<X> getCteCriteria(String cteName) {
        return this.cteStatements.get(cteName);
    }

    public <X> JpaCteCriteria<X> with(AbstractQuery<X> criteria) {
        return this.withInternal(SqmCreationHelper.acquireUniqueAlias(), criteria);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionAll(AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(SqmCreationHelper.acquireUniqueAlias(), baseCriteria, false, recursiveCriteriaProducer);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionDistinct(AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(SqmCreationHelper.acquireUniqueAlias(), baseCriteria, true, recursiveCriteriaProducer);
    }

    public <X> JpaCteCriteria<X> with(String name, AbstractQuery<X> criteria) {
        return this.withInternal(this.validateCteName(name), criteria);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionAll(String name, AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(this.validateCteName(name), baseCriteria, false, recursiveCriteriaProducer);
    }

    public <X> JpaCteCriteria<X> withRecursiveUnionDistinct(String name, AbstractQuery<X> baseCriteria, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        return this.withInternal(this.validateCteName(name), baseCriteria, true, recursiveCriteriaProducer);
    }

    private String validateCteName(String name) {
        if (name == null || name.isBlank()) {
            throw new IllegalArgumentException("Illegal empty CTE name");
        }
        if (!Character.isAlphabetic(name.charAt(0))) {
            throw new IllegalArgumentException(String.format("Illegal CTE name [%s]. Names must start with an alphabetic character!", name));
        }
        return name;
    }

    private <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> criteria) {
        SqmCteStatement cteStatement = new SqmCteStatement(name, (SqmSelectQuery)criteria, this, this.nodeBuilder());
        if (this.cteStatements.putIfAbsent(name, cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists");
        }
        return cteStatement;
    }

    private <X> JpaCteCriteria<X> withInternal(String name, AbstractQuery<X> baseCriteria, boolean unionDistinct, Function<JpaCteCriteria<X>, AbstractQuery<X>> recursiveCriteriaProducer) {
        SqmCteStatement cteStatement = new SqmCteStatement(name, (SqmSelectQuery)baseCriteria, unionDistinct, recursiveCriteriaProducer, this, this.nodeBuilder());
        if (this.cteStatements.putIfAbsent(name, cteStatement) != null) {
            throw new IllegalArgumentException("A CTE with the label " + cteStatement.getCteTable().getCteName() + " already exists");
        }
        return cteStatement;
    }

    @Override
    public SqmRoot<E> getTarget() {
        return this.target;
    }

    @Override
    public void setTarget(JpaRoot<E> root) {
        this.target = (SqmRoot)root;
    }

    public <U> SqmSubQuery<U> subquery(Class<U> type) {
        return new SqmSubQuery<U>(this, type, this.nodeBuilder());
    }

    protected void appendHqlCteString(StringBuilder sb) {
        if (!this.cteStatements.isEmpty()) {
            sb.append("with ");
            for (SqmCteStatement<?> value : this.cteStatements.values()) {
                value.appendHqlString(sb);
                sb.append(", ");
            }
            sb.setLength(sb.length() - 2);
        }
    }
}

