/*
 * Decompiled with CFR 0.152.
 */
package org.infinispan.client.hotrod.impl.operations;

import io.netty.buffer.ByteBuf;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.infinispan.client.hotrod.DataFormat;
import org.infinispan.client.hotrod.configuration.Configuration;
import org.infinispan.client.hotrod.impl.ClientStatistics;
import org.infinispan.client.hotrod.impl.ClientTopology;
import org.infinispan.client.hotrod.impl.operations.HotRodOperation;
import org.infinispan.client.hotrod.impl.operations.StatsAffectingHotRodOperation;
import org.infinispan.client.hotrod.impl.protocol.Codec;
import org.infinispan.client.hotrod.impl.transport.netty.ChannelFactory;
import org.infinispan.client.hotrod.impl.transport.netty.HeaderDecoder;

public abstract class ParallelHotRodOperation<T, SUBOP extends HotRodOperation<T>>
extends StatsAffectingHotRodOperation<T> {
    protected final ChannelFactory channelFactory;

    protected ParallelHotRodOperation(Codec codec, ChannelFactory channelFactory, byte[] cacheName, AtomicReference<ClientTopology> clientTopology, int flags, Configuration cfg, DataFormat dataFormat, ClientStatistics clientStatistics) {
        super((short)0, (short)0, codec, flags, cfg, cacheName, clientTopology, channelFactory, dataFormat, clientStatistics);
        this.channelFactory = channelFactory;
    }

    @Override
    public CompletableFuture<T> execute() {
        List<SUBOP> operations = this.mapOperations();
        if (operations.isEmpty()) {
            return CompletableFuture.completedFuture(this.createCollector());
        }
        if (operations.size() == 1) {
            return ((HotRodOperation)operations.get(0)).execute();
        }
        return this.executeParallel(operations);
    }

    private CompletableFuture<T> executeParallel(List<SUBOP> operations) {
        T collector = this.createCollector();
        AtomicInteger counter = new AtomicInteger(operations.size());
        for (HotRodOperation operation : operations) {
            operation.execute().whenComplete((T result, U throwable) -> {
                if (throwable != null) {
                    this.completeExceptionally((Throwable)throwable);
                } else {
                    if (collector != null) {
                        Object object = collector;
                        synchronized (object) {
                            this.combine(collector, result);
                        }
                    }
                    if (counter.decrementAndGet() == 0) {
                        this.complete(collector);
                    }
                }
            });
        }
        this.exceptionally((T throwable) -> {
            for (HotRodOperation operation : operations) {
                operation.cancel(true);
            }
            return null;
        });
        return this;
    }

    protected abstract List<SUBOP> mapOperations();

    protected abstract T createCollector();

    protected abstract void combine(T var1, T var2);

    @Override
    public void acceptResponse(ByteBuf buf, short status, HeaderDecoder decoder) {
        throw new UnsupportedOperationException();
    }
}

