/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.junit5.extension;

import io.quarkus.test.junit.main.LaunchResult;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.List;
import org.junit.jupiter.api.Assertions;
import org.keycloak.quarkus.runtime.cli.Picocli;
import picocli.CommandLine;

public interface CLIResult
extends LaunchResult {
    public static Object create(final List<String> outputStream, final List<String> errStream, final int exitCode, final boolean distribution) {
        return new CLIResult(){

            public List<String> getOutputStream() {
                return outputStream;
            }

            public List<String> getErrorStream() {
                return errStream;
            }

            public int exitCode() {
                return exitCode;
            }

            @Override
            public boolean isDistribution() {
                return distribution;
            }
        };
    }

    public boolean isDistribution();

    default public void assertStarted() {
        Assertions.assertFalse((boolean)this.getOutput().contains("The delayed handler's queue was overrun and log record(s) were lost (Did you forget to configure logging?)"), () -> "The standard Output:\n" + this.getOutput() + "should not contain a warning about log queue overrun.");
        Assertions.assertTrue((boolean)this.getOutput().contains("Listening on:"), () -> "The standard output:\n" + this.getOutput() + "does include \"Listening on:\"");
        this.assertNotDevMode();
    }

    default public void assertNotDevMode() {
        Assertions.assertFalse((boolean)this.getOutput().contains("Running the server in dev mode."), () -> "The standard output:\n" + this.getOutput() + "does include the Start Dev output");
    }

    default public void assertStartedDevMode() {
        Assertions.assertTrue((boolean)this.getOutput().contains("Running the server in dev mode."), () -> "The standard output:\n" + this.getOutput() + "doesn't include the Start Dev output");
    }

    default public void assertError(String msg) {
        Assertions.assertTrue((boolean)this.getErrorOutput().contains(msg), () -> "The Error Output:\n " + this.getErrorOutput() + "\ndoesn't contains " + msg);
    }

    default public void assertHelp(String command) {
        if (command == null) {
            Assertions.fail((String)"No command provided");
        }
        CommandLine cmd = Picocli.createCommandLine(Arrays.asList(command, "--help"));
        if (this.isDistribution()) {
            cmd.setCommandName("kc.sh");
        }
        try (ByteArrayOutputStream outStream = new ByteArrayOutputStream();
             PrintStream printStream = new PrintStream(outStream, true);){
            if ("kc.sh".equals(command)) {
                cmd.usage(printStream);
            } else {
                ((CommandLine)cmd.getSubcommands().get(command)).usage(printStream);
            }
            Assertions.assertTrue((boolean)this.getOutput().trim().equals(outStream.toString().trim()), () -> "The Output:\n " + this.getOutput() + "\ndoesnt't contains " + outStream.toString().trim());
        }
        catch (IOException cause) {
            throw new RuntimeException("Failed to assert help", cause);
        }
    }
}

