/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.it.utils;

import io.restassured.RestAssured;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import java.util.concurrent.Future;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.jboss.logging.Logger;
import org.keycloak.common.Version;
import org.keycloak.it.utils.KeycloakDistribution;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.output.OutputFrame;
import org.testcontainers.containers.output.ToStringConsumer;
import org.testcontainers.images.builder.ImageFromDockerfile;

public final class DockerKeycloakDistribution
implements KeycloakDistribution {
    private static final Logger LOGGER = Logger.getLogger(DockerKeycloakDistribution.class);
    private boolean debug;
    private boolean manualStop;
    private int exitCode = -1;
    private String stdout = "";
    private String stderr = "";
    private ToStringConsumer backupConsumer = new ToStringConsumer();
    private File distributionFile = new File("../../../distribution/server-x-dist/target/keycloak.x-" + Version.VERSION_KEYCLOAK + ".tar.gz");
    private File cachedDockerfile = this.createDockerCacheFile();
    private boolean dockerfileFetched = false;
    private GenericContainer keycloakContainer = null;

    private File createDockerCacheFile() {
        try {
            File tmp = File.createTempFile("Dockerfile", "keycloak.x");
            tmp.deleteOnExit();
            return tmp;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void fetchDockerfile() {
        if (!this.dockerfileFetched) {
            try {
                FileUtils.copyURLToFile((URL)new URL("https://raw.githubusercontent.com/keycloak/keycloak-containers/main/server-x/Dockerfile"), (File)this.cachedDockerfile);
                this.dockerfileFetched = true;
            }
            catch (Exception cause) {
                throw new RuntimeException("Cannot download upstream Dockerfile", cause);
            }
        }
    }

    private GenericContainer getKeycloakContainer() {
        if (!this.distributionFile.exists()) {
            throw new RuntimeException("Distribution archive " + this.distributionFile.getAbsolutePath() + " doesn't exists");
        }
        this.fetchDockerfile();
        return new GenericContainer((Future)((ImageFromDockerfile)((ImageFromDockerfile)new ImageFromDockerfile().withFileFromFile("keycloakx.tar.gz", this.distributionFile)).withFileFromFile("Dockerfile", this.cachedDockerfile)).withBuildArg("KEYCLOAK_DIST", "keycloakx.tar.gz")).withExposedPorts(new Integer[]{8080});
    }

    public <T> DockerKeycloakDistribution(boolean debug, boolean manualStop, boolean reCreate) {
        this.debug = debug;
        this.manualStop = manualStop;
    }

    @Override
    public void start(List<String> arguments) {
        try {
            this.exitCode = -1;
            this.stdout = "";
            this.stderr = "";
            this.backupConsumer = new ToStringConsumer();
            this.keycloakContainer = this.getKeycloakContainer();
            this.keycloakContainer.withLogConsumer((Consumer)this.backupConsumer).withCommand(arguments.toArray(new String[0])).start();
            RestAssured.port = this.keycloakContainer.getMappedPort(8080);
        }
        catch (Exception cause) {
            this.exitCode = -1;
            this.stdout = this.backupConsumer.toUtf8String();
            this.stderr = this.backupConsumer.toUtf8String();
            this.keycloakContainer = null;
            LOGGER.warn((Object)"Failed to start Keycloak container", (Throwable)cause);
        }
    }

    @Override
    public void stop() {
        try {
            if (this.keycloakContainer != null) {
                this.stdout = this.fetchOutputStream();
                this.stderr = this.fetchErrorStream();
                this.keycloakContainer.stop();
                this.exitCode = 0;
            }
        }
        catch (Exception cause) {
            this.exitCode = -1;
            throw new RuntimeException("Failed to stop the server", cause);
        }
        finally {
            this.keycloakContainer = null;
        }
    }

    private String fetchOutputStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDOUT});
        }
        if (this.stdout.isEmpty()) {
            return this.backupConsumer.toUtf8String();
        }
        return this.stdout;
    }

    @Override
    public List<String> getOutputStream() {
        return List.of(this.fetchOutputStream().split("\n"));
    }

    public String fetchErrorStream() {
        if (this.keycloakContainer != null && this.keycloakContainer.isRunning()) {
            return this.keycloakContainer.getLogs(new OutputFrame.OutputType[]{OutputFrame.OutputType.STDERR});
        }
        if (this.stderr.isEmpty()) {
            return this.backupConsumer.toUtf8String();
        }
        return this.stderr;
    }

    @Override
    public List<String> getErrorStream() {
        return List.of(this.fetchErrorStream().split("\n"));
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public boolean isManualStop() {
        return this.manualStop;
    }
}

