/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.deployment;

import io.quarkus.arc.deployment.SyntheticBeanBuildItem;
import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.Consume;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.runtime.ShutdownContext;
import jakarta.enterprise.context.ApplicationScoped;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.stream.Collectors;
import org.infinispan.commons.util.FileLookupFactory;
import org.keycloak.config.MetricsOptions;
import org.keycloak.quarkus.deployment.KeycloakProcessor;
import org.keycloak.quarkus.deployment.KeycloakSessionFactoryPreInitBuildItem;
import org.keycloak.quarkus.runtime.KeycloakRecorder;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.storage.legacy.infinispan.CacheManagerFactory;

public class CacheBuildSteps {
    @Consume(value=KeycloakSessionFactoryPreInitBuildItem.class)
    @Record(value=ExecutionTime.RUNTIME_INIT)
    @BuildStep
    void configureInfinispan(KeycloakRecorder recorder, BuildProducer<SyntheticBeanBuildItem> syntheticBeanBuildItems, ShutdownContextBuildItem shutdownContext) {
        block9: {
            String configFile = Configuration.getConfigValue((String)"kc.spi-connections-infinispan-quarkus-config-file").getValue();
            if (configFile != null) {
                Path configPath = Paths.get(configFile, new String[0]);
                String path = configPath.toFile().exists() ? configPath.toFile().getAbsolutePath() : configPath.getFileName().toString();
                InputStream url = FileLookupFactory.newInstance().lookupFile(path, KeycloakProcessor.class.getClassLoader());
                if (url == null) {
                    throw new IllegalArgumentException("Could not load cluster configuration file at [" + configPath + "]");
                }
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(url));){
                    String config = reader.lines().collect(Collectors.joining("\n"));
                    syntheticBeanBuildItems.produce((BuildItem)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)((SyntheticBeanBuildItem.ExtendedBeanConfigurator)SyntheticBeanBuildItem.configure(CacheManagerFactory.class).scope(ApplicationScoped.class)).unremovable()).setRuntimeInit().runtimeValue(recorder.createCacheInitializer(config, this.isMetricsEnabled(), (ShutdownContext)shutdownContext)).done());
                    break block9;
                }
                catch (Exception cause) {
                    throw new RuntimeException("Failed to read clustering configuration from [" + url + "]", cause);
                }
            }
            throw new IllegalArgumentException("Option 'configFile' needs to be specified");
        }
    }

    private boolean isMetricsEnabled() {
        return Configuration.getOptionalBooleanValue((String)"kc.".concat(MetricsOptions.METRICS_ENABLED.getKey())).orElse(false);
    }
}

