/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.cli;

import io.quarkus.runtime.Quarkus;
import io.quarkus.runtime.annotations.QuarkusMain;
import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import org.keycloak.cli.Picocli;
import org.keycloak.common.Version;
import org.keycloak.util.Environment;
import picocli.CommandLine;

@QuarkusMain(name="keycloak")
public class KeycloakMain {
    public static void main(String[] cliArgs) {
        System.setProperty("kc.version", Version.VERSION_KEYCLOAK);
        if (cliArgs.length == 0) {
            KeycloakMain.start(Collections.emptyList(), new PrintWriter(System.err));
            System.exit(0);
        }
        KeycloakMain.parseAndRun(cliArgs);
    }

    static void start(CommandLine cmd) {
        KeycloakMain.start(Picocli.getCliArgs(cmd), cmd.getErr());
    }

    private static void start(List<String> cliArgs, PrintWriter errorWriter) {
        Quarkus.run(null, (integer, throwable) -> Picocli.error(cliArgs, errorWriter, String.format("Failed to start server using profile (%s).", Environment.getProfileOrDefault("none")), throwable.getCause()), (String[])new String[0]);
        Quarkus.waitForExit();
    }

    private static void parseAndRun(String[] args) {
        LinkedList<String> cliArgs = new LinkedList<String>(Arrays.asList(args));
        CommandLine cmd = Picocli.createCommandLine();
        System.setProperty("kc.config.args", Picocli.parseConfigArgs(cliArgs));
        try {
            CommandLine.ParseResult result = cmd.parseArgs(cliArgs.toArray(new String[cliArgs.size()]));
            if (!(result.hasSubcommand() || result.isUsageHelpRequested() || result.isVersionHelpRequested())) {
                cliArgs.add(0, "start");
            }
        }
        catch (CommandLine.UnmatchedArgumentException e) {
            if (!cmd.getParseResult().hasSubcommand() && ((String)cliArgs.get(0)).startsWith("--")) {
                cliArgs.add(0, "start");
            } else {
                cmd.getErr().println(e.getMessage());
                System.exit(cmd.getCommandSpec().exitCodeOnInvalidInput());
            }
        }
        catch (Exception e) {
            cmd.getErr().println(e.getMessage());
            System.exit(cmd.getCommandSpec().exitCodeOnExecutionException());
        }
        System.exit(cmd.execute(cliArgs.toArray(new String[cliArgs.size()])));
    }
}

