/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.configuration;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import java.util.function.Supplier;

public class PropertyMapper {
    static Map<String, PropertyMapper> MAPPERS = new HashMap<String, PropertyMapper>();
    static PropertyMapper IDENTITY = new PropertyMapper(null, null, null, null, null){

        @Override
        public ConfigValue getOrDefault(String name, ConfigSourceInterceptorContext context, ConfigValue current) {
            return current;
        }
    };
    private final String to;
    private final String from;
    private final String defaultValue;
    private final BiFunction<String, ConfigSourceInterceptorContext, String> mapper;
    private final String mapFrom;
    private final boolean buildTime;
    private String description;
    private boolean mask;

    static PropertyMapper create(String fromProperty, String toProperty, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, null, null, description));
    }

    static PropertyMapper createWithDefault(String fromProperty, String toProperty, String defaultValue, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, defaultValue, null, description));
    }

    static PropertyMapper createWithDefault(String fromProperty, String toProperty, Supplier<String> defaultValue, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, (String)defaultValue.get(), null, description));
    }

    static PropertyMapper createWithDefault(String fromProperty, String toProperty, String defaultValue, BiFunction<String, ConfigSourceInterceptorContext, String> transformer, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, defaultValue, transformer, description));
    }

    static PropertyMapper create(String fromProperty, String toProperty, BiFunction<String, ConfigSourceInterceptorContext, String> transformer, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, null, transformer, null, description));
    }

    static PropertyMapper create(String fromProperty, String toProperty, String description, boolean mask) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, null, null, null, false, description, mask));
    }

    static PropertyMapper create(String fromProperty, String mapFrom, String toProperty, BiFunction<String, ConfigSourceInterceptorContext, String> transformer, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, null, transformer, mapFrom, description));
    }

    static PropertyMapper createBuildTimeProperty(String fromProperty, String toProperty, BiFunction<String, ConfigSourceInterceptorContext, String> transformer, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, null, transformer, null, true, description, false));
    }

    static PropertyMapper createBuildTimeProperty(String fromProperty, String toProperty, String description) {
        return MAPPERS.computeIfAbsent(toProperty, s -> new PropertyMapper(fromProperty, (String)s, null, null, null, true, description, false));
    }

    private static String defaultTransformer(String value, ConfigSourceInterceptorContext context) {
        return value;
    }

    PropertyMapper(String from, String to, String defaultValue, BiFunction<String, ConfigSourceInterceptorContext, String> mapper, String description) {
        this(from, to, defaultValue, mapper, null, description);
    }

    PropertyMapper(String from, String to, String defaultValue, BiFunction<String, ConfigSourceInterceptorContext, String> mapper, String mapFrom, String description) {
        this(from, to, defaultValue, mapper, mapFrom, false, description, false);
    }

    PropertyMapper(String from, String to, String defaultValue, BiFunction<String, ConfigSourceInterceptorContext, String> mapper, String mapFrom, boolean buildTime, String description, boolean mask) {
        this.from = "kc." + from;
        this.to = to;
        this.defaultValue = defaultValue;
        this.mapper = mapper == null ? PropertyMapper::defaultTransformer : mapper;
        this.mapFrom = mapFrom;
        this.buildTime = buildTime;
        this.description = description;
        this.mask = mask;
    }

    ConfigValue getOrDefault(ConfigSourceInterceptorContext context, ConfigValue current) {
        return this.getOrDefault(null, context, current);
    }

    ConfigValue getOrDefault(String name, ConfigSourceInterceptorContext context, ConfigValue current) {
        ConfigValue config = context.proceed(this.from);
        if (config == null) {
            ConfigValue value;
            String parentKey;
            ConfigValue parentValue;
            if (this.mapFrom != null && (parentValue = context.proceed(parentKey = "kc." + this.mapFrom)) != null && (value = this.transformValue(parentValue.getValue(), context)) != null) {
                return value;
            }
            if (this.defaultValue == null || current != null && !current.getConfigSourceName().equalsIgnoreCase("default values")) {
                return current;
            }
            if (this.mapper != null) {
                return this.transformValue(this.defaultValue, context);
            }
            return ConfigValue.builder().withName(this.to).withValue(this.defaultValue).build();
        }
        if (this.mapFrom != null) {
            return config;
        }
        ConfigValue value = this.transformValue(config.getValue(), context);
        if (value == null) {
            return current;
        }
        return value;
    }

    public String getFrom() {
        return this.from;
    }

    public String getDescription() {
        return this.description;
    }

    private ConfigValue transformValue(String value, ConfigSourceInterceptorContext context) {
        if (value == null) {
            return null;
        }
        if (this.mapper == null) {
            return ConfigValue.builder().withName(this.to).withValue(value).build();
        }
        String mappedValue = this.mapper.apply(value, context);
        if (mappedValue != null) {
            return ConfigValue.builder().withName(this.to).withValue(mappedValue).build();
        }
        return null;
    }

    boolean isBuildTime() {
        return this.buildTime;
    }

    boolean isMask() {
        return this.mask;
    }

    String getTo() {
        return this.to;
    }
}

