/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.connections.liquibase;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import liquibase.database.Database;
import liquibase.database.DatabaseFactory;
import liquibase.exception.ServiceNotFoundException;
import liquibase.logging.Logger;
import liquibase.servicelocator.DefaultPackageScanClassResolver;
import liquibase.servicelocator.PackageScanClassResolver;
import liquibase.servicelocator.ServiceLocator;
import org.keycloak.connections.liquibase.KeycloakLogger;

public class FastServiceLocator
extends ServiceLocator {
    private final Map<String, List<String>> services;

    public FastServiceLocator(final Map<String, List<String>> services) {
        super((PackageScanClassResolver)new DefaultPackageScanClassResolver(){

            public Set<Class<?>> findImplementations(Class parent, String ... packageNames) {
                List found = (List)services.get(parent.getName());
                if (found == null) {
                    return super.findImplementations(parent, packageNames);
                }
                HashSet ret = new HashSet();
                for (String i : found) {
                    try {
                        ret.add(Class.forName(i, false, Thread.currentThread().getContextClassLoader()));
                    }
                    catch (ClassNotFoundException e) {
                        e.printStackTrace();
                    }
                }
                return ret;
            }
        });
        if (!System.getProperties().containsKey("liquibase.scan.packages")) {
            if (this.getPackages().remove("liquibase.core")) {
                this.addPackageToScan("liquibase.core.xml");
            }
            if (this.getPackages().remove("liquibase.parser")) {
                this.addPackageToScan("liquibase.parser.core.xml");
            }
            if (this.getPackages().remove("liquibase.serializer")) {
                this.addPackageToScan("liquibase.serializer.core.xml");
            }
            this.getPackages().remove("liquibase.ext");
            this.getPackages().remove("liquibase.sdk");
        }
        this.getPackages().remove("liquibase.parser.core.yaml");
        this.getPackages().remove("liquibase.serializer.core.yaml");
        this.getPackages().remove("liquibase.parser.core.json");
        this.getPackages().remove("liquibase.serializer.core.json");
        this.services = services;
    }

    public Object newInstance(Class requiredInterface) throws ServiceNotFoundException {
        if (Logger.class.equals((Object)requiredInterface)) {
            return new KeycloakLogger();
        }
        return super.newInstance(requiredInterface);
    }

    public <T> Class<? extends T>[] findClasses(Class<T> requiredInterface) throws ServiceNotFoundException {
        List<String> found = this.services.get(requiredInterface.getName());
        if (found == null) {
            return super.findClasses(requiredInterface);
        }
        HashSet ret = new HashSet();
        for (String i : found) {
            try {
                ret.add(Class.forName(i, false, Thread.currentThread().getContextClassLoader()));
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
        }
        return ret.toArray(new Class[ret.size()]);
    }

    public void register(Database database) {
        DatabaseFactory.getInstance().register(database);
    }
}

