/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.provider.quarkus;

import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.infinispan.commons.marshall.Marshaller;
import org.infinispan.commons.util.FileLookupFactory;
import org.infinispan.configuration.cache.ConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.jboss.marshalling.core.JBossUserMarshaller;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.logging.Logger;
import org.keycloak.Config;
import org.keycloak.cluster.ManagedCacheManagerProvider;
import org.keycloak.util.Environment;

public final class QuarkusCacheManagerProvider
implements ManagedCacheManagerProvider {
    private static final Logger log = Logger.getLogger(QuarkusCacheManagerProvider.class);

    public <C> C getCacheManager(Config.Scope config) {
        try {
            ConfigurationBuilderHolder builder = new ParserRegistry().parse(this.loadConfiguration(config));
            if (((ConfigurationBuilder)builder.getNamedConfigurationBuilders().get("sessions")).clustering().cacheMode().isClustered()) {
                this.configureTransportStack(config, builder);
            }
            builder.getGlobalConfigurationBuilder().serialization().marshaller((Marshaller)new JBossUserMarshaller());
            return (C)new DefaultCacheManager(builder, false);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private URL loadConfiguration(Config.Scope config) {
        String pathPrefix;
        String homeDir = Environment.getHomeDir();
        if (homeDir == null) {
            log.warn((Object)"Keycloak home directory not set");
            pathPrefix = "";
        } else {
            pathPrefix = homeDir + "/conf/";
        }
        String configFile = config.get("configFile");
        if (configFile != null) {
            Path configPath = Paths.get(pathPrefix + configFile, new String[0]);
            String path = configPath.toFile().exists() ? configPath.toFile().getAbsolutePath() : configPath.getFileName().toString();
            log.infof("Loading cluster configuration from %s", (Object)configPath);
            URL url = FileLookupFactory.newInstance().lookupFileLocation(path, Thread.currentThread().getContextClassLoader());
            if (url == null) {
                throw new IllegalArgumentException("Could not load cluster configuration file at [" + configPath + "]");
            }
            return url;
        }
        throw new IllegalArgumentException("Option 'configFile' needs to be specified");
    }

    private void configureTransportStack(Config.Scope config, ConfigurationBuilderHolder builder) {
        String transportStack = config.get("stack");
        if (transportStack != null) {
            builder.getGlobalConfigurationBuilder().transport().defaultTransport().addProperty("configurationFile", "default-configs/default-jgroups-" + transportStack + ".xml");
        }
    }
}

