/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.PropertiesConfigSource;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.BiConsumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.cli.Picocli;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class ConfigArgsConfigSource
extends PropertiesConfigSource {
    private static final Logger log = Logger.getLogger(ConfigArgsConfigSource.class);
    public static final String CLI_ARGS = "kc.config.args";
    private static final String ARG_SEPARATOR = ";;";
    private static final Pattern ARG_SPLIT = Pattern.compile(";;");
    private static final Pattern ARG_KEY_VALUE_SPLIT = Pattern.compile("=");
    private static final ConfigArgsConfigSource INSTANCE = new ConfigArgsConfigSource();
    private static List<String> IGNORED_ARGS;
    private final boolean alwaysParseArgs = Environment.isTestLaunchMode();

    public static ConfigArgsConfigSource getInstance() {
        return INSTANCE;
    }

    ConfigArgsConfigSource() {
        super(ConfigArgsConfigSource.parseArgument(), "CliConfigSource", 500);
    }

    public static void setCliArgs(String[] args) {
        System.setProperty(CLI_ARGS, String.join((CharSequence)ARG_SEPARATOR, args));
    }

    public static List<String> getAllCliArgs() {
        if (System.getProperty(CLI_ARGS) == null) {
            return Collections.emptyList();
        }
        return List.of(System.getProperty(CLI_ARGS).split(ARG_SEPARATOR));
    }

    private static String getRawConfigArgs() {
        return System.getProperty(CLI_ARGS, "");
    }

    public String getValue(String propertyName) {
        String value;
        Map<String, String> properties = this.getProperties();
        if (this.alwaysParseArgs) {
            properties = ConfigArgsConfigSource.parseArgument();
        }
        if ((value = properties.get(propertyName)) != null) {
            return value;
        }
        return properties.get(propertyName.replace('-', '.'));
    }

    private static Map<String, String> parseArgument() {
        IGNORED_ARGS = Arrays.asList("--verbose", "-v", "--help", "-h", "--auto-build", "-b");
        String rawArgs = ConfigArgsConfigSource.getRawConfigArgs();
        if (rawArgs == null || "".equals(rawArgs.trim())) {
            log.trace((Object)"No command-line arguments provided");
            return Collections.emptyMap();
        }
        final HashMap<String, String> properties = new HashMap<String, String>();
        ConfigArgsConfigSource.parseConfigArgs(new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                key = "kc." + ((String)key).substring(2);
                log.tracef("Adding property [%s=%s] from command-line", key, (Object)value);
                properties.put(key, value);
                String mappedPropertyName = Configuration.getMappedPropertyName((String)key);
                properties.put(mappedPropertyName, value);
                PropertyMapper mapper = PropertyMappers.getMapper(mappedPropertyName);
                if (mapper != null) {
                    properties.put(mapper.getFrom(), value);
                }
                properties.put(Picocli.normalizeKey((String)key), value);
            }
        });
        return properties;
    }

    public static boolean hasOptionValue(final Predicate<String> keyMatcher, final String expectedValue) {
        final AtomicBoolean result = new AtomicBoolean();
        ConfigArgsConfigSource.parseConfigArgs(new BiConsumer<String, String>(){

            @Override
            public void accept(String key, String value) {
                if (keyMatcher.test(key) && expectedValue.equals(value)) {
                    result.set(true);
                }
            }
        });
        return result.get();
    }

    public static void parseConfigArgs(BiConsumer<String, String> cliArgConsumer) {
        String rawArgs = ConfigArgsConfigSource.getRawConfigArgs();
        if (rawArgs == null || "".equals(rawArgs.trim())) {
            log.trace((Object)"No command-line arguments provided");
            return;
        }
        String[] args = ARG_SPLIT.split(rawArgs);
        for (int i = 0; i < args.length; ++i) {
            String value;
            String arg = args[i];
            if (IGNORED_ARGS.contains(arg) || !arg.startsWith("-")) continue;
            String[] keyValue = ARG_KEY_VALUE_SPLIT.split(arg);
            String key = keyValue[0];
            if ("".equals(key.trim())) {
                throw new IllegalArgumentException("Invalid argument key");
            }
            if (keyValue.length == 1) {
                if (args.length <= i + 1) continue;
                value = args[i + 1];
            } else {
                value = keyValue.length == 2 ? keyValue[1] : arg.substring(key.length() + 1);
            }
            cliArgConsumer.accept(key, value);
        }
    }
}

