/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Arrays;
import java.util.Collections;
import java.util.function.BiFunction;
import org.keycloak.quarkus.runtime.configuration.mappers.ConfigCategory;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMappers;

public class PropertyMapper {
    static PropertyMapper IDENTITY = new PropertyMapper(null, null, null, null, null, false, null, null, false, (Iterable)Collections.emptyList(), null, true){

        @Override
        public ConfigValue getConfigValue(String name, ConfigSourceInterceptorContext context) {
            return context.proceed(name);
        }
    };
    private final String to;
    private final String from;
    private final String defaultValue;
    private final BiFunction<String, ConfigSourceInterceptorContext, String> mapper;
    private final String mapFrom;
    private final boolean buildTime;
    private final String description;
    private final boolean mask;
    private final Iterable<String> expectedValues;
    private final ConfigCategory category;
    private final String paramLabel;
    private final boolean hidden;
    private String cliFormat;

    PropertyMapper(String from, String to, String defaultValue, BiFunction<String, ConfigSourceInterceptorContext, String> mapper, String mapFrom, boolean buildTime, String description, String paramLabel, boolean mask, Iterable<String> expectedValues, ConfigCategory category, boolean hidden) {
        this.from = "kc." + from;
        this.to = to == null ? this.from : to;
        this.defaultValue = defaultValue;
        this.mapper = mapper == null ? PropertyMapper::defaultTransformer : mapper;
        this.mapFrom = mapFrom;
        this.buildTime = buildTime;
        this.description = description;
        this.paramLabel = paramLabel;
        this.mask = mask;
        this.expectedValues = expectedValues == null ? Collections.emptyList() : expectedValues;
        this.category = category != null ? category : ConfigCategory.GENERAL;
        this.hidden = hidden;
        this.setCliFormat(this.from);
    }

    public static Builder builder(String fromProp, String toProp) {
        return new Builder(fromProp, toProp);
    }

    public static Builder builder(ConfigCategory category) {
        return new Builder(category);
    }

    private static String defaultTransformer(String value, ConfigSourceInterceptorContext context) {
        return value;
    }

    ConfigValue getConfigValue(ConfigSourceInterceptorContext context) {
        return this.getConfigValue(this.to, context);
    }

    ConfigValue getConfigValue(String name, ConfigSourceInterceptorContext context) {
        ConfigValue config;
        String from = this.from;
        if (this.to != null && this.to.endsWith(".")) {
            from = name.replace(this.to.substring(0, this.to.lastIndexOf(46)), from.substring(0, from.lastIndexOf(46)));
        }
        if ((config = context.proceed(from)) == null) {
            ConfigValue current;
            if (this.mapFrom != null) {
                PropertyMapper parentMapper;
                String parentKey = "kc." + this.mapFrom;
                ConfigValue parentValue = context.proceed(parentKey);
                if (parentValue == null && (parentMapper = PropertyMappers.getMapper(parentKey)) != null) {
                    parentValue = ConfigValue.builder().withValue(parentMapper.getDefaultValue()).build();
                }
                if (parentValue != null) {
                    ConfigValue value = this.transformValue(parentValue.getValue(), context);
                    if (value != null) {
                        return value;
                    }
                    return parentValue;
                }
            }
            if ((current = context.proceed(name)) == null) {
                return this.transformValue(this.defaultValue, context);
            }
            return current;
        }
        if (config.getName().equals(name)) {
            return config;
        }
        ConfigValue value = this.transformValue(config.getValue(), context);
        if (value == null) {
            return context.proceed(name);
        }
        return value;
    }

    public String getFrom() {
        return this.from;
    }

    public String getDescription() {
        return this.description;
    }

    public Iterable<String> getExpectedValues() {
        return this.expectedValues;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public ConfigCategory getCategory() {
        return this.category;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public boolean isBuildTime() {
        return this.buildTime;
    }

    public String getTo() {
        return this.to;
    }

    public String getParamLabel() {
        return this.paramLabel;
    }

    public String getCliFormat() {
        return this.cliFormat;
    }

    boolean isMask() {
        return this.mask;
    }

    private ConfigValue transformValue(String value, ConfigSourceInterceptorContext context) {
        if (value == null) {
            return null;
        }
        if (this.mapper == null) {
            return ConfigValue.builder().withName(this.to).withValue(value).build();
        }
        String mappedValue = this.mapper.apply(value, context);
        if (mappedValue != null) {
            return ConfigValue.builder().withName(this.to).withValue(mappedValue).build();
        }
        return null;
    }

    private void setCliFormat(String from) {
        this.cliFormat = "--" + PropertyMappers.toCLIFormat(from).substring(3);
    }

    public static class Builder {
        private String from;
        private String to;
        private String defaultValue;
        private BiFunction<String, ConfigSourceInterceptorContext, String> mapper;
        private String description;
        private String mapFrom = null;
        private Iterable<String> expectedValues = Collections.emptyList();
        private boolean isBuildTimeProperty = false;
        private boolean isMasked = false;
        private ConfigCategory category = ConfigCategory.GENERAL;
        private String paramLabel;
        private boolean hidden;

        public Builder(ConfigCategory category) {
            this.category = category;
        }

        public Builder(String fromProp, String toProp) {
            this.from = fromProp;
            this.to = toProp;
        }

        public Builder from(String from) {
            this.from = from;
            return this;
        }

        public Builder to(String to) {
            this.to = to;
            return this;
        }

        public Builder defaultValue(String defaultValue) {
            this.defaultValue = defaultValue;
            return this;
        }

        public Builder transformer(BiFunction<String, ConfigSourceInterceptorContext, String> mapper) {
            this.mapper = mapper;
            return this;
        }

        public Builder description(String description) {
            this.description = description;
            return this;
        }

        public Builder paramLabel(String label) {
            this.paramLabel = label;
            return this;
        }

        public Builder mapFrom(String mapFrom) {
            this.mapFrom = mapFrom;
            return this;
        }

        public Builder expectedValues(Iterable<String> expectedValues) {
            this.expectedValues = expectedValues;
            return this;
        }

        public Builder expectedValues(String ... expectedValues) {
            this.expectedValues = Arrays.asList(expectedValues);
            return this;
        }

        public Builder isBuildTimeProperty(boolean isBuildTime) {
            this.isBuildTimeProperty = isBuildTime;
            return this;
        }

        public Builder isMasked(boolean isMasked) {
            this.isMasked = isMasked;
            return this;
        }

        public Builder category(ConfigCategory category) {
            this.category = category;
            return this;
        }

        public Builder type(Class<Boolean> type) {
            if (Boolean.class.equals(type)) {
                this.expectedValues(Boolean.TRUE.toString(), Boolean.FALSE.toString());
                this.paramLabel(this.defaultValue == null ? "true|false" : this.defaultValue);
                this.defaultValue(this.defaultValue == null ? Boolean.FALSE.toString() : this.defaultValue);
            }
            return this;
        }

        public Builder hidden(boolean hidden) {
            this.hidden = hidden;
            return this;
        }

        public PropertyMapper build() {
            return new PropertyMapper(this.from, this.to, this.defaultValue, this.mapper, this.mapFrom, this.isBuildTimeProperty, this.description, this.paramLabel, this.isMasked, this.expectedValues, this.category, this.hidden);
        }
    }
}

