/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.infinispan;

import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.manager.DefaultCacheManager;
import org.jboss.logging.Logger;

public class CacheManagerFactory {
    private ConfigurationBuilderHolder config;
    private DefaultCacheManager cacheManager;
    private Future<DefaultCacheManager> cacheManagerFuture;
    private ExecutorService executor;
    private boolean initialized;

    public CacheManagerFactory(ConfigurationBuilderHolder config) {
        this.config = config;
        this.executor = this.createThreadPool();
        this.cacheManagerFuture = this.executor.submit(this::startCacheManager);
    }

    public DefaultCacheManager getOrCreate() {
        if (this.cacheManager == null) {
            if (this.initialized) {
                return null;
            }
            try {
                DefaultCacheManager defaultCacheManager = this.cacheManager = this.cacheManagerFuture.get(this.getStartTimeout().intValue(), TimeUnit.SECONDS);
                return defaultCacheManager;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to start caches", e);
            }
            finally {
                this.shutdownThreadPool();
            }
        }
        return this.cacheManager;
    }

    private ExecutorService createThreadPool() {
        return Executors.newSingleThreadExecutor(new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, "keycloak-cache-init");
            }
        });
    }

    private DefaultCacheManager startCacheManager() {
        return new DefaultCacheManager(this.config, this.isStartEagerly());
    }

    private boolean isStartEagerly() {
        return Boolean.parseBoolean(System.getProperty("kc.cache.ispn.start-eagerly", Boolean.TRUE.toString()));
    }

    private Integer getStartTimeout() {
        return Integer.getInteger("kc.cache.ispn.start-timeout", 120);
    }

    private void shutdownThreadPool() {
        if (this.executor != null) {
            this.executor.shutdown();
            try {
                if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                    this.executor.shutdownNow();
                    if (!this.executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                        Logger.getLogger(CacheManagerFactory.class).warn((Object)"Cache init thread pool not terminated");
                    }
                }
            }
            catch (Exception cause) {
                this.executor.shutdownNow();
            }
            finally {
                this.executor = null;
                this.cacheManagerFuture = null;
                this.config = null;
                this.initialized = true;
            }
        }
    }
}

