/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime;

import org.keycloak.quarkus.runtime.Environment;
import picocli.CommandLine;

public final class Messages {
    private Messages() {
    }

    public static IllegalArgumentException invalidDatabaseVendor(String db, String ... availableOptions) {
        return new IllegalArgumentException("Invalid database vendor [" + db + "]. Possible values are: " + String.join((CharSequence)", ", availableOptions) + ".");
    }

    public static IllegalArgumentException invalidProxyMode(String mode) {
        return new IllegalArgumentException("Invalid value [" + mode + "] for configuration property [proxy].");
    }

    public static IllegalStateException httpsConfigurationNotSet() {
        StringBuilder builder = new StringBuilder("Key material not provided to setup HTTPS. Please configure your keys/certificates");
        if (!"dev".equals(Environment.getProfile())) {
            builder.append(" or start the server in development mode");
        }
        builder.append(".");
        return new IllegalStateException(builder.toString());
    }

    public static void cliExecutionError(CommandLine cmd, String message, Throwable cause) {
        throw new CommandLine.ExecutionException(cmd, message, cause);
    }

    public static String devProfileNotAllowedError(String cmd) {
        return String.format("You can not '%s' the server using the '%s' configuration profile. Please re-build the server first, using 'kc.sh build' for the default production profile, or using 'kc.sh build --profile=<profile>' with a profile more suitable for production.%n", cmd, "dev");
    }
}

