/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration;

import io.quarkus.runtime.ShutdownEvent;
import io.quarkus.runtime.StartupEvent;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import org.keycloak.platform.Platform;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;

@ApplicationScoped
public class QuarkusLifecycleObserver {
    void onStartupEvent(@Observes StartupEvent event) {
        QuarkusPlatform platform = (QuarkusPlatform)Platform.getPlatform();
        platform.started();
        QuarkusPlatform.exitOnError();
        Runnable startupHook = platform.startupHook;
        if (startupHook != null) {
            startupHook.run();
        }
    }

    void onShutdownEvent(@Observes ShutdownEvent event) {
        Runnable shutdownHook = ((QuarkusPlatform)Platform.getPlatform()).shutdownHook;
        if (shutdownHook != null) {
            shutdownHook.run();
        }
    }
}

