/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.web;

import io.vertx.ext.web.RoutingContext;
import java.lang.annotation.Annotation;
import java.security.cert.X509Certificate;
import javax.enterprise.inject.Instance;
import javax.enterprise.inject.spi.CDI;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import org.jboss.logging.Logger;
import org.jboss.resteasy.spi.HttpRequest;
import org.keycloak.services.x509.X509ClientCertificateLookup;

public class VertxClientCertificateLookup
implements X509ClientCertificateLookup {
    private static final Logger logger = Logger.getLogger(VertxClientCertificateLookup.class);

    public void close() {
    }

    public X509Certificate[] getCertificateChain(HttpRequest httpRequest) {
        Instance instances = CDI.current().select(RoutingContext.class, new Annotation[0]);
        if (instances.isResolvable()) {
            RoutingContext context = (RoutingContext)instances.get();
            try {
                SSLSession sslSession = context.request().sslSession();
                if (sslSession == null) {
                    return null;
                }
                X509Certificate[] certificates = (X509Certificate[])sslSession.getPeerCertificates();
                if (logger.isTraceEnabled() && certificates != null) {
                    for (X509Certificate cert : certificates) {
                        logger.tracef("Certificate's SubjectDN => \"%s\"", (Object)cert.getSubjectDN().getName());
                    }
                }
                return certificates;
            }
            catch (SSLPeerUnverifiedException sSLPeerUnverifiedException) {
                // empty catch block
            }
        }
        return null;
    }
}

