/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Optional;
import org.keycloak.config.CachingOptions;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

final class CachingPropertyMappers {
    private CachingPropertyMappers() {
    }

    public static PropertyMapper[] getClusteringPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(CachingOptions.CACHE).paramLabel("type").build(), PropertyMapper.fromOption(CachingOptions.CACHE_STACK).to("kc.spi-connections-infinispan-quarkus-stack").paramLabel("stack").build(), PropertyMapper.fromOption(CachingOptions.CACHE_CONFIG_FILE).mapFrom("cache").to("kc.spi-connections-infinispan-quarkus-config-file").transformer(CachingPropertyMappers::resolveConfigFile).paramLabel("file").build()};
    }

    private static Optional<String> resolveConfigFile(Optional<String> value, ConfigSourceInterceptorContext context) {
        if ("local".equals(value.get())) {
            return Optional.of("cache-local.xml");
        }
        if ("ispn".equals(value.get())) {
            return Optional.of("cache-ispn.xml");
        }
        String homeDir = Environment.getHomeDir();
        Object pathPrefix = homeDir == null ? "" : homeDir + "/conf/";
        return Optional.of((String)pathPrefix + value.get());
    }
}

