/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Optional;
import org.keycloak.config.ProxyOptions;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;

final class ProxyPropertyMappers {
    private ProxyPropertyMappers() {
    }

    public static PropertyMapper[] getProxyPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(ProxyOptions.PROXY).to("quarkus.http.proxy.proxy-address-forwarding").transformer(ProxyPropertyMappers::getValidProxyModeValue).paramLabel("mode").build(), PropertyMapper.fromOption(ProxyOptions.PROXY_FORWARDED_HOST).to("quarkus.http.proxy.enable-forwarded-host").mapFrom("proxy").transformer(ProxyPropertyMappers::getResolveEnableForwardedHost).build()};
    }

    private static Optional<String> getValidProxyModeValue(Optional<String> value, ConfigSourceInterceptorContext context) {
        String mode;
        switch (mode = value.get()) {
            case "none": {
                return Optional.of(Boolean.FALSE.toString());
            }
            case "edge": 
            case "reencrypt": 
            case "passthrough": {
                return Optional.of(Boolean.TRUE.toString());
            }
        }
        QuarkusPlatform.addInitializationException(Messages.invalidProxyMode(mode));
        return Optional.of(Boolean.FALSE.toString());
    }

    private static Optional<String> getResolveEnableForwardedHost(Optional<String> proxy, ConfigSourceInterceptorContext context) {
        return Optional.of(String.valueOf(!ProxyOptions.Mode.none.name().equals(proxy)));
    }
}

