/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.integration.jaxrs;

import java.util.Set;
import java.util.stream.Collectors;
import javax.ws.rs.ApplicationPath;
import org.keycloak.exportimport.ExportImportManager;
import org.keycloak.models.utils.PostMigrationEvent;
import org.keycloak.provider.ProviderEvent;
import org.keycloak.quarkus.runtime.integration.QuarkusKeycloakSessionFactory;
import org.keycloak.quarkus.runtime.services.resources.QuarkusWelcomeResource;
import org.keycloak.services.resources.KeycloakApplication;
import org.keycloak.services.resources.WelcomeResource;

@ApplicationPath(value="/")
public class QuarkusKeycloakApplication
extends KeycloakApplication {
    private static boolean filterSingletons(Object o) {
        return !WelcomeResource.class.isInstance(o);
    }

    protected void startup() {
        QuarkusKeycloakSessionFactory instance = QuarkusKeycloakSessionFactory.getInstance();
        sessionFactory = instance;
        instance.init();
        ExportImportManager exportImportManager = this.bootstrap();
        if (exportImportManager.isRunExport()) {
            exportImportManager.runExport();
        }
        sessionFactory.publish((ProviderEvent)new PostMigrationEvent(sessionFactory));
    }

    protected void loadConfig() {
    }

    public Set<Object> getSingletons() {
        Set<Object> singletons = super.getSingletons().stream().filter(QuarkusKeycloakApplication::filterSingletons).collect(Collectors.toSet());
        singletons.add(new QuarkusWelcomeResource());
        return singletons;
    }
}

