/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.cli.command;

import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.keycloak.config.OptionCategory;
import org.keycloak.quarkus.runtime.Environment;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.cli.command.AbstractStartCommand;
import org.keycloak.quarkus.runtime.cli.command.HelpAllMixin;
import org.keycloak.quarkus.runtime.cli.command.ImportRealmMixin;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import picocli.CommandLine;

@CommandLine.Command(name="start", header={"Start the server."}, description={"%nUse this command to run the server in production."}, footer={"%nBy default, this command tries to update the server configuration by running a 'build' before starting the server. You can disable this behavior by using the '--optimized' option:%n%n      $ ${PARENT-COMMAND-FULL-NAME:-$PARENTCOMMAND} ${COMMAND-NAME} '--optimized'%n%nBy doing that, the server should start faster based on any previous configuration you have set when manually running the 'build' command."})
public final class Start
extends AbstractStartCommand
implements Runnable {
    public static final String NAME = "start";
    @CommandLine.Option(names={"-b", "--auto-build"}, description={"(Deprecated) Automatically detects whether the server configuration changed and a new server image must be built prior to starting the server. This option provides an alternative to manually running the 'build' prior to starting the server. Use this configuration carefully in production as it might impact the startup time."}, paramLabel="none", order=1)
    Boolean autoConfig;
    @CommandLine.Option(names={"--optimized"}, description={"Use this option to achieve an optional startup time if you have previously built a server image using the 'build' command."}, paramLabel="none", order=1)
    Boolean optimized;
    @CommandLine.Mixin
    ImportRealmMixin importRealmMixin;
    @CommandLine.Mixin
    HelpAllMixin helpAllMixin;

    @Override
    protected void doBeforeRun() {
        this.devProfileNotAllowedError();
    }

    private void devProfileNotAllowedError() {
        if (Start.isDevProfileNotAllowed(this.spec.commandLine().getParseResult().expandedArgs())) {
            this.executionError(this.spec.commandLine(), Messages.devProfileNotAllowedError(NAME));
        }
    }

    public static boolean isDevProfileNotAllowed(List<String> currentCliArgs) {
        Optional<String> currentProfile = Optional.ofNullable(Environment.getProfile());
        Optional<String> persistedProfile = Configuration.getRawPersistedProperty("kc.profile");
        Environment.setProfile(currentProfile.orElse(persistedProfile.orElse("prod")));
        return Environment.isDevProfile() && (!currentCliArgs.contains("--auto-build") || !currentCliArgs.contains("-b"));
    }

    @Override
    public List<OptionCategory> getOptionCategories() {
        return super.getOptionCategories().stream().filter(optionCategory -> optionCategory != OptionCategory.EXPORT && optionCategory != OptionCategory.IMPORT).collect(Collectors.toList());
    }

    @Override
    public boolean includeRuntime() {
        return true;
    }
}

