/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import io.smallrye.config.ConfigValue;
import java.util.Optional;
import org.keycloak.config.DatabaseOptions;
import org.keycloak.config.StorageOptions;
import org.keycloak.config.database.Database;
import org.keycloak.quarkus.runtime.Messages;
import org.keycloak.quarkus.runtime.configuration.Configuration;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;
import org.keycloak.quarkus.runtime.integration.QuarkusPlatform;

final class DatabasePropertyMappers {
    private DatabasePropertyMappers() {
    }

    public static PropertyMapper[] getDatabasePropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(DatabaseOptions.DB_DIALECT).mapFrom("db").to("quarkus.hibernate-orm.dialect").transformer(DatabasePropertyMappers::transformDialect).build(), PropertyMapper.fromOption(DatabaseOptions.DB_DRIVER).mapFrom("db").to("quarkus.datasource.jdbc.driver").transformer(DatabasePropertyMappers::getXaOrNonXaDriver).paramLabel("driver").build(), PropertyMapper.fromOption(DatabaseOptions.DB).transformer(DatabasePropertyMappers::resolveDatabaseVendor).to("quarkus.datasource.db-kind").transformer(DatabasePropertyMappers::toDatabaseKind).paramLabel("vendor").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL).to("quarkus.datasource.jdbc.url").mapFrom("db").transformer(DatabasePropertyMappers::getDatabaseUrl).paramLabel("jdbc-url").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_HOST).to("kc.db-url-host").paramLabel("hostname").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_DATABASE).to("kc.db-url-database").paramLabel("dbname").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_PORT).to("kc.db-url-port").paramLabel("port").build(), PropertyMapper.fromOption(DatabaseOptions.DB_URL_PROPERTIES).to("kc.db-url-properties").paramLabel("properties").build(), PropertyMapper.fromOption(DatabaseOptions.DB_USERNAME).to("quarkus.datasource.username").mapFrom("db").transformer(DatabasePropertyMappers::resolveUsername).paramLabel("username").build(), PropertyMapper.fromOption(DatabaseOptions.DB_PASSWORD).to("quarkus.datasource.password").mapFrom("db").transformer(DatabasePropertyMappers::resolvePassword).paramLabel("password").isMasked(true).build(), PropertyMapper.fromOption(DatabaseOptions.DB_SCHEMA).to("quarkus.hibernate-orm.database.default-schema").paramLabel("schema").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POOL_INITIAL_SIZE).to("quarkus.datasource.jdbc.initial-size").paramLabel("size").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POOL_MIN_SIZE).to("quarkus.datasource.jdbc.min-size").paramLabel("size").build(), PropertyMapper.fromOption(DatabaseOptions.DB_POOL_MAX_SIZE).to("quarkus.datasource.jdbc.max-size").paramLabel("size").build()};
    }

    private static Optional<String> getDatabaseUrl(Optional<String> value, ConfigSourceInterceptorContext c) {
        Optional url = Database.getDefaultUrl((String)value.get());
        if (url.isPresent()) {
            if (DatabasePropertyMappers.isJpaStore()) {
                return Database.getDefaultUrl((String)DatabasePropertyMappers.getJpaStoreDbVendor().name().toLowerCase());
            }
            return url;
        }
        return value;
    }

    private static Optional<String> getXaOrNonXaDriver(Optional<String> value, ConfigSourceInterceptorContext context) {
        Optional driver;
        boolean isJtaEnabled;
        if (DatabasePropertyMappers.isJpaStore()) {
            return Database.getDriver((String)DatabasePropertyMappers.getJpaStoreDbVendor().name().toLowerCase(), (boolean)true);
        }
        ConfigValue xaEnabledConfigValue = context.proceed("kc.transaction-xa-enabled");
        ConfigValue jtaEnabledConfiguration = context.proceed("kc.transaction-jta-enabled");
        boolean isXaEnabled = xaEnabledConfigValue == null || Boolean.parseBoolean(xaEnabledConfigValue.getValue());
        boolean bl = isJtaEnabled = jtaEnabledConfiguration == null || Boolean.parseBoolean(jtaEnabledConfiguration.getValue());
        if (!isJtaEnabled) {
            isXaEnabled = false;
        }
        if ((driver = Database.getDriver((String)value.get(), (boolean)isXaEnabled)).isPresent()) {
            return driver;
        }
        return value;
    }

    private static Optional<String> toDatabaseKind(Optional<String> db, ConfigSourceInterceptorContext context) {
        if (DatabasePropertyMappers.isJpaStore()) {
            return Database.getDatabaseKind((String)DatabasePropertyMappers.getJpaStoreDbVendor().name().toLowerCase());
        }
        Optional databaseKind = Database.getDatabaseKind((String)db.get());
        if (databaseKind.isPresent()) {
            return databaseKind;
        }
        QuarkusPlatform.addInitializationException(Messages.invalidDatabaseVendor(db.get(), Database.getLegacyStoreAliases()));
        return Optional.of("h2");
    }

    private static Optional<String> resolveDatabaseVendor(Optional<String> db, ConfigSourceInterceptorContext context) {
        if (DatabasePropertyMappers.isJpaStore()) {
            return Optional.of(DatabasePropertyMappers.getJpaStoreDbVendor().name().toLowerCase());
        }
        if (db.isEmpty()) {
            return Optional.of("dev-file");
        }
        return db;
    }

    private static Optional<String> resolveUsername(Optional<String> value, ConfigSourceInterceptorContext context) {
        if (DatabasePropertyMappers.isDevModeDatabase(context)) {
            return Optional.of("sa");
        }
        return Database.getDatabaseKind((String)value.get()).isEmpty() ? value : null;
    }

    private static Optional<String> resolvePassword(Optional<String> value, ConfigSourceInterceptorContext context) {
        if (DatabasePropertyMappers.isDevModeDatabase(context)) {
            return Optional.of("password");
        }
        return Database.getDatabaseKind((String)value.get()).isEmpty() ? value : null;
    }

    private static boolean isDevModeDatabase(ConfigSourceInterceptorContext context) {
        if (DatabasePropertyMappers.isJpaStore()) {
            return false;
        }
        String db = Configuration.getConfig().getConfigValue("kc.db").getValue();
        return ((String)Database.getDatabaseKind((String)db).get()).equals("h2");
    }

    private static Optional<String> transformDialect(Optional<String> db, ConfigSourceInterceptorContext context) {
        if (DatabasePropertyMappers.isJpaStore()) {
            return Optional.of("org.keycloak.models.map.storage.jpa.hibernate.dialect.JsonbPostgreSQL95Dialect");
        }
        Optional databaseKind = Database.getDatabaseKind((String)db.get());
        if (databaseKind.isEmpty()) {
            return db;
        }
        Optional dialect = Database.getDialect((String)db.get());
        if (dialect.isPresent()) {
            return dialect;
        }
        return Database.getDialect((String)"dev-file");
    }

    private static boolean isJpaStore() {
        String storage = Configuration.getRawValue("kc.".concat(StorageOptions.STORAGE.getKey()));
        return storage != null && StorageOptions.StorageType.jpa.name().equals(storage);
    }

    private static Database.Vendor getJpaStoreDbVendor() {
        String storageJpaDb = Configuration.getRawValue("kc.".concat(StorageOptions.STORAGE_JPA_DB.getKey()));
        return StorageOptions.getDatabaseVendor((String)storageJpaDb).orElse(Database.Vendor.POSTGRES);
    }
}

