/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration.mappers;

import io.smallrye.config.ConfigSourceInterceptorContext;
import java.util.Optional;
import org.keycloak.config.TransactionOptions;
import org.keycloak.quarkus.runtime.configuration.mappers.PropertyMapper;

public class TransactionPropertyMappers {
    private static final String QUARKUS_TXPROP_TARGET = "quarkus.datasource.jdbc.transactions";

    private TransactionPropertyMappers() {
    }

    public static PropertyMapper[] getTransactionPropertyMappers() {
        return new PropertyMapper[]{PropertyMapper.fromOption(TransactionOptions.TRANSACTION_XA_ENABLED).to(QUARKUS_TXPROP_TARGET).transformer(TransactionPropertyMappers::getQuarkusTransactionsValue).build()};
    }

    private static Optional<String> getQuarkusTransactionsValue(Optional<String> txValue, ConfigSourceInterceptorContext context) {
        boolean isXaEnabled = Boolean.parseBoolean(txValue.get());
        if (isXaEnabled) {
            return Optional.of("xa");
        }
        return Optional.of("enabled");
    }
}

