/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.storage.infinispan;

import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Metrics;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.stream.Stream;
import javax.net.ssl.SSLContext;
import org.infinispan.client.hotrod.MetadataValue;
import org.infinispan.client.hotrod.RemoteCache;
import org.infinispan.client.hotrod.RemoteCacheManager;
import org.infinispan.client.hotrod.RemoteCacheManagerAdmin;
import org.infinispan.client.hotrod.configuration.ConfigurationBuilder;
import org.infinispan.client.hotrod.configuration.ExhaustedAction;
import org.infinispan.commons.api.Lifecycle;
import org.infinispan.commons.dataconversion.MediaType;
import org.infinispan.commons.util.concurrent.CompletableFutures;
import org.infinispan.configuration.cache.CacheMode;
import org.infinispan.configuration.cache.Configuration;
import org.infinispan.configuration.cache.HashConfiguration;
import org.infinispan.configuration.cache.PersistenceConfigurationBuilder;
import org.infinispan.configuration.global.GlobalConfiguration;
import org.infinispan.configuration.global.GlobalConfigurationBuilder;
import org.infinispan.configuration.global.TransportConfigurationBuilder;
import org.infinispan.configuration.parsing.ConfigurationBuilderHolder;
import org.infinispan.configuration.parsing.ParserRegistry;
import org.infinispan.manager.DefaultCacheManager;
import org.infinispan.metrics.config.MicrometerMeterRegisterConfigurationBuilder;
import org.infinispan.persistence.remote.configuration.RemoteStoreConfigurationBuilder;
import org.infinispan.protostream.descriptors.Descriptor;
import org.infinispan.protostream.descriptors.FileDescriptor;
import org.jboss.logging.Logger;
import org.jgroups.conf.ProtocolConfiguration;
import org.jgroups.protocols.TCP_NIO2;
import org.jgroups.protocols.UDP;
import org.jgroups.util.TLS;
import org.jgroups.util.TLSClientAuth;
import org.keycloak.common.Profile;
import org.keycloak.common.util.MultiSiteUtils;
import org.keycloak.config.CachingOptions;
import org.keycloak.config.MetricsOptions;
import org.keycloak.config.Option;
import org.keycloak.connections.infinispan.InfinispanConnectionProvider;
import org.keycloak.infinispan.util.InfinispanUtils;
import org.keycloak.marshalling.KeycloakIndexSchemaUtil;
import org.keycloak.marshalling.KeycloakModelSchema;
import org.keycloak.marshalling.Marshalling;
import org.keycloak.models.sessions.infinispan.query.ClientSessionQueries;
import org.keycloak.models.sessions.infinispan.query.UserSessionQueries;
import org.keycloak.models.sessions.infinispan.remote.RemoteInfinispanAuthenticationSessionProviderFactory;
import org.keycloak.models.sessions.infinispan.remote.RemoteUserLoginFailureProviderFactory;

public class CacheManagerFactory {
    private static final Logger logger = Logger.getLogger(CacheManagerFactory.class);
    private final CompletableFuture<DefaultCacheManager> cacheManagerFuture;
    private final CompletableFuture<RemoteCacheManager> remoteCacheManagerFuture;

    public CacheManagerFactory(String config) {
        this.cacheManagerFuture = this.startEmbeddedCacheManager(config);
        if (InfinispanUtils.isRemoteInfinispan()) {
            logger.debug((Object)"Remote Cache feature is enabled");
            this.remoteCacheManagerFuture = CompletableFuture.supplyAsync(this::startRemoteCacheManager);
        } else {
            logger.debug((Object)"Remote Cache feature is disabled");
            this.remoteCacheManagerFuture = CompletableFutures.completedNull();
        }
    }

    public DefaultCacheManager getOrCreateEmbeddedCacheManager() {
        return CacheManagerFactory.join(this.cacheManagerFuture);
    }

    public RemoteCacheManager getOrCreateRemoteCacheManager() {
        return CacheManagerFactory.join(this.remoteCacheManagerFuture);
    }

    public void shutdown() {
        logger.debug((Object)"Shutdown embedded and remote cache managers");
        this.cacheManagerFuture.thenAccept(CacheManagerFactory::close);
        this.remoteCacheManagerFuture.thenAccept(CacheManagerFactory::close);
    }

    private static <T> T join(Future<T> future) {
        try {
            return future.get(CacheManagerFactory.getStartTimeout(), TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        catch (ExecutionException | TimeoutException e) {
            throw new RuntimeException("Failed to start embedded or remote cache manager", e);
        }
    }

    private static void close(Lifecycle lifecycle) {
        if (lifecycle != null) {
            lifecycle.stop();
        }
    }

    private RemoteCacheManager startRemoteCacheManager() {
        logger.info((Object)"Starting Infinispan remote cache manager (Hot Rod Client)");
        String cacheRemoteHost = CacheManagerFactory.requiredStringProperty("cache-remote-host");
        Integer cacheRemotePort = org.keycloak.quarkus.runtime.configuration.Configuration.getOptionalKcValue("cache-remote-port").map(Integer::parseInt).orElse(11222);
        String cacheRemoteUsername = CacheManagerFactory.requiredStringProperty("cache-remote-username");
        String cacheRemotePassword = CacheManagerFactory.requiredStringProperty("cache-remote-password");
        ConfigurationBuilder builder = new ConfigurationBuilder();
        builder.addServer().host(cacheRemoteHost).port(cacheRemotePort.intValue());
        builder.connectionPool().maxActive(16).exhaustedAction(ExhaustedAction.CREATE_NEW);
        if (CacheManagerFactory.isRemoteTLSEnabled()) {
            builder.security().ssl().enable().sslContext(CacheManagerFactory.createSSLContext()).sniHostName(cacheRemoteHost);
        }
        if (CacheManagerFactory.isRemoteAuthenticationEnabled()) {
            builder.security().authentication().enable().username(cacheRemoteUsername).password(cacheRemotePassword).realm("default").saslMechanism("SCRAM-SHA-512");
        }
        Marshalling.configure((ConfigurationBuilder)builder);
        if (CacheManagerFactory.shouldCreateRemoteCaches()) {
            CacheManagerFactory.createRemoteCaches(builder);
        }
        RemoteCacheManager remoteCacheManager = new RemoteCacheManager(builder.build());
        this.updateProtoSchema(remoteCacheManager);
        if (CacheManagerFactory.isStartEagerly()) {
            InfinispanConnectionProvider.skipSessionsCacheIfRequired(Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES)).forEach(arg_0 -> ((RemoteCacheManager)remoteCacheManager).getCache(arg_0));
        }
        return remoteCacheManager;
    }

    private static void createRemoteCaches(ConfigurationBuilder builder) {
        logger.warn((Object)"Creating remote cache in external Infinispan server. It should not be used in production!");
        Configuration baseConfig = CacheManagerFactory.defaultRemoteCacheBuilder().build();
        InfinispanConnectionProvider.skipSessionsCacheIfRequired(Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES)).forEach(name -> builder.remoteCache(name).configuration(baseConfig.toStringConfiguration(name)));
    }

    private static org.infinispan.configuration.cache.ConfigurationBuilder defaultRemoteCacheBuilder() {
        org.infinispan.configuration.cache.ConfigurationBuilder builder = new org.infinispan.configuration.cache.ConfigurationBuilder();
        builder.clustering().cacheMode(CacheMode.DIST_SYNC);
        builder.encoding().mediaType(MediaType.APPLICATION_PROTOSTREAM);
        return builder;
    }

    private void updateProtoSchema(RemoteCacheManager remoteCacheManager) {
        String key = KeycloakModelSchema.INSTANCE.getProtoFileName();
        String current = KeycloakModelSchema.INSTANCE.getProtoFile();
        RemoteCache protostreamMetadataCache = remoteCacheManager.getCache("___protobuf_metadata");
        MetadataValue stored = protostreamMetadataCache.getWithMetadata((Object)key);
        if (stored == null) {
            if (protostreamMetadataCache.putIfAbsent((Object)key, (Object)current) == null) {
                logger.info((Object)"Infinispan ProtoStream schema uploaded for the first time.");
            } else {
                logger.info((Object)"Failed to update Infinispan ProtoStream schema. Assumed it was updated by other Keycloak server.");
            }
            this.checkForProtoSchemaErrors((RemoteCache<String, String>)protostreamMetadataCache);
            return;
        }
        if (Objects.equals(stored.getValue(), current)) {
            logger.info((Object)"Infinispan ProtoStream schema is up to date!");
            return;
        }
        if (protostreamMetadataCache.replaceWithVersion((Object)key, (Object)current, stored.getVersion())) {
            logger.info((Object)"Infinispan ProtoStream schema successful updated.");
            CacheManagerFactory.reindexCaches(remoteCacheManager, (String)stored.getValue(), current);
        } else {
            logger.info((Object)"Failed to update Infinispan ProtoStream schema. Assumed it was updated by other Keycloak server.");
        }
        this.checkForProtoSchemaErrors((RemoteCache<String, String>)protostreamMetadataCache);
    }

    private void checkForProtoSchemaErrors(RemoteCache<String, String> protostreamMetadataCache) {
        String errors = (String)protostreamMetadataCache.get((Object)".errors");
        if (errors != null) {
            for (String errorFile : errors.split("\n")) {
                logger.errorf("%nThere was an error in proto file: %s%nError message: %s%nCurrent proto schema: %s%n", (Object)errorFile, protostreamMetadataCache.get((Object)(errorFile + ".errors")), protostreamMetadataCache.get((Object)errorFile));
            }
        }
    }

    private static void reindexCaches(RemoteCacheManager remoteCacheManager, String oldSchema, String newSchema) {
        FileDescriptor oldPS = KeycloakModelSchema.parseProtoSchema((String)oldSchema);
        FileDescriptor newPS = KeycloakModelSchema.parseProtoSchema((String)newSchema);
        RemoteCacheManagerAdmin admin = remoteCacheManager.administration();
        if (CacheManagerFactory.isEntityChanged(oldPS, newPS, RemoteUserLoginFailureProviderFactory.PROTO_ENTITY)) {
            CacheManagerFactory.updateSchemaAndReIndexCache(admin, "loginFailures");
        }
        if (CacheManagerFactory.isEntityChanged(oldPS, newPS, RemoteInfinispanAuthenticationSessionProviderFactory.PROTO_ENTITY)) {
            CacheManagerFactory.updateSchemaAndReIndexCache(admin, "authenticationSessions");
        }
        if (CacheManagerFactory.isEntityChanged(oldPS, newPS, ClientSessionQueries.CLIENT_SESSION)) {
            CacheManagerFactory.updateSchemaAndReIndexCache(admin, "clientSessions");
            CacheManagerFactory.updateSchemaAndReIndexCache(admin, "offlineClientSessions");
        }
        if (CacheManagerFactory.isEntityChanged(oldPS, newPS, UserSessionQueries.USER_SESSION)) {
            CacheManagerFactory.updateSchemaAndReIndexCache(admin, "sessions");
            CacheManagerFactory.updateSchemaAndReIndexCache(admin, "offlineSessions");
        }
    }

    private static boolean isEntityChanged(FileDescriptor oldSchema, FileDescriptor newSchema, String entity) {
        Optional v1 = KeycloakModelSchema.findEntity((FileDescriptor)oldSchema, (String)entity);
        Optional v2 = KeycloakModelSchema.findEntity((FileDescriptor)newSchema, (String)entity);
        return v1.isPresent() && v2.isPresent() && KeycloakIndexSchemaUtil.isIndexSchemaChanged((Descriptor)((Descriptor)v1.get()), (Descriptor)((Descriptor)v2.get()));
    }

    private static void updateSchemaAndReIndexCache(RemoteCacheManagerAdmin admin, String cacheName) {
        admin.updateIndexSchema(cacheName);
        admin.reindexCache(cacheName);
    }

    private CompletableFuture<DefaultCacheManager> startEmbeddedCacheManager(String config) {
        logger.info((Object)"Starting Infinispan embedded cache manager");
        ConfigurationBuilderHolder builder = new ParserRegistry().parse(config);
        if (org.keycloak.quarkus.runtime.configuration.Configuration.isTrue((Option<Boolean>)MetricsOptions.METRICS_ENABLED)) {
            builder.getGlobalConfigurationBuilder().addModule(MicrometerMeterRegisterConfigurationBuilder.class);
            ((MicrometerMeterRegisterConfigurationBuilder)builder.getGlobalConfigurationBuilder().module(MicrometerMeterRegisterConfigurationBuilder.class)).meterRegistry((MeterRegistry)Metrics.globalRegistry);
            builder.getGlobalConfigurationBuilder().cacheContainer().statistics(true);
            builder.getGlobalConfigurationBuilder().metrics().namesAsTags(true);
            if (org.keycloak.quarkus.runtime.configuration.Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_METRICS_HISTOGRAMS_ENABLED)) {
                builder.getGlobalConfigurationBuilder().metrics().histograms(true);
            }
            builder.getNamedConfigurationBuilders().forEach((s, configurationBuilder) -> configurationBuilder.statistics().enabled(true));
        }
        Marshalling.configure((GlobalConfigurationBuilder)builder.getGlobalConfigurationBuilder());
        if (InfinispanUtils.isRemoteInfinispan()) {
            Map builders = builder.getNamedConfigurationBuilders();
            logger.debug((Object)"Removing all distributed caches.");
            for (String cacheName : InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES) {
                if (CacheManagerFactory.hasRemoteStore((org.infinispan.configuration.cache.ConfigurationBuilder)builders.get(cacheName))) {
                    logger.warnf("remote-store configuration detected for cache '%s'. Explicit cache configuration ignored when using '%s' or '%s' Features.", (Object)cacheName, (Object)Profile.Feature.CLUSTERLESS.getKey(), (Object)Profile.Feature.MULTI_SITE.getKey());
                }
                builders.remove(cacheName);
            }
            builder.getGlobalConfigurationBuilder().nonClusteredDefault();
        } else {
            if (builder.getNamedConfigurationBuilders().entrySet().stream().anyMatch(c -> ((org.infinispan.configuration.cache.ConfigurationBuilder)c.getValue()).clustering().cacheMode().isClustered())) {
                CacheManagerFactory.configureTransportStack(builder);
                CacheManagerFactory.configureRemoteStores(builder);
            }
            CacheManagerFactory.configureCacheMaxCount(builder, CachingOptions.CLUSTERED_MAX_COUNT_CACHES);
            CacheManagerFactory.configureSessionsCaches(builder);
        }
        CacheManagerFactory.configureCacheMaxCount(builder, CachingOptions.LOCAL_MAX_COUNT_CACHES);
        CacheManagerFactory.checkForRemoteStores(builder);
        boolean start = CacheManagerFactory.isStartEagerly();
        return CompletableFuture.supplyAsync(() -> new DefaultCacheManager(builder, start));
    }

    private static boolean isRemoteTLSEnabled() {
        return org.keycloak.quarkus.runtime.configuration.Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_REMOTE_TLS_ENABLED);
    }

    private static boolean isRemoteAuthenticationEnabled() {
        return org.keycloak.quarkus.runtime.configuration.Configuration.getOptionalKcValue("cache-remote-username").isPresent() || org.keycloak.quarkus.runtime.configuration.Configuration.getOptionalKcValue("cache-remote-password").isPresent();
    }

    private static boolean shouldCreateRemoteCaches() {
        return Boolean.getBoolean("kc.cache-remote-create-caches");
    }

    private static SSLContext createSSLContext() {
        try {
            SSLContext sslContext = SSLContext.getInstance("TLS");
            sslContext.init(null, null, null);
            return sslContext;
        }
        catch (KeyManagementException | NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    private static boolean isStartEagerly() {
        return Boolean.parseBoolean(System.getProperty("kc.cache-ispn-start-eagerly", Boolean.TRUE.toString()));
    }

    private static int getStartTimeout() {
        return Integer.getInteger("kc.cache-ispn-start-timeout", 120);
    }

    private static void configureTransportStack(ConfigurationBuilderHolder builder) {
        String transportStack = org.keycloak.quarkus.runtime.configuration.Configuration.getRawValue("kc.cache-stack");
        TransportConfigurationBuilder transportConfig = builder.getGlobalConfigurationBuilder().transport();
        if (transportStack != null && !transportStack.isBlank()) {
            transportConfig.defaultTransport().stack(transportStack);
        }
        if (org.keycloak.quarkus.runtime.configuration.Configuration.isTrue((Option<Boolean>)CachingOptions.CACHE_EMBEDDED_MTLS_ENABLED)) {
            CacheManagerFactory.validateTlsAvailable(transportConfig.build());
            TLS tls = new TLS().enabled(true).setKeystorePath(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-key-store-file")).setKeystorePassword(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-key-store-password")).setKeystoreType("pkcs12").setTruststorePath(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-trust-store-file")).setTruststorePassword(CacheManagerFactory.requiredStringProperty("cache-embedded-mtls-trust-store-password")).setTruststoreType("pkcs12").setClientAuth(TLSClientAuth.NEED).setProtocols(new String[]{"TLSv1.3"});
            transportConfig.addProperty("socketFactory", (Object)tls.createSocketFactory());
            Logger.getLogger(CacheManagerFactory.class).info((Object)"MTLS enabled for communications for embedded caches");
        }
    }

    private static void validateTlsAvailable(GlobalConfiguration config) {
        String stackName = config.transport().stack();
        if (stackName == null) {
            return;
        }
        for (ProtocolConfiguration protocol : config.transport().jgroups().configurator(stackName).getProtocolStack()) {
            String name = protocol.getProtocolName();
            if (!name.equals(UDP.class.getSimpleName()) && !name.equals(UDP.class.getName()) && !name.equals(TCP_NIO2.class.getSimpleName()) && !name.equals(TCP_NIO2.class.getName())) continue;
            throw new RuntimeException("Cache TLS is not available with protocol " + name);
        }
    }

    private static void configureRemoteStores(ConfigurationBuilderHolder builder) {
        if (org.keycloak.quarkus.runtime.configuration.Configuration.getOptionalKcValue("cache-remote-host").isPresent()) {
            String cacheRemoteHost = CacheManagerFactory.requiredStringProperty("cache-remote-host");
            Integer cacheRemotePort = org.keycloak.quarkus.runtime.configuration.Configuration.getOptionalKcValue("cache-remote-port").map(Integer::parseInt).orElse(11222);
            SSLContext sslContext = CacheManagerFactory.createSSLContext();
            Arrays.stream(InfinispanConnectionProvider.CLUSTERED_CACHE_NAMES).forEach(cacheName -> {
                PersistenceConfigurationBuilder persistenceCB = ((org.infinispan.configuration.cache.ConfigurationBuilder)builder.getNamedConfigurationBuilders().get(cacheName)).persistence();
                if (!persistenceCB.stores().isEmpty()) {
                    throw new RuntimeException(String.format("Remote store for cache '%s' is already configured via CLI parameters. It should not be present in the XML file.", cacheName));
                }
                RemoteStoreConfigurationBuilder storeBuilder = (RemoteStoreConfigurationBuilder)persistenceCB.addStore(RemoteStoreConfigurationBuilder.class);
                ((RemoteStoreConfigurationBuilder)((RemoteStoreConfigurationBuilder)storeBuilder.rawValues(true).shared(true)).segmented(false)).remoteCacheName(cacheName).connectionPool().maxActive(16).exhaustedAction(org.infinispan.persistence.remote.configuration.ExhaustedAction.CREATE_NEW).addServer().host(cacheRemoteHost).port(cacheRemotePort.intValue());
                if (CacheManagerFactory.isRemoteTLSEnabled()) {
                    storeBuilder.remoteSecurity().ssl().enable().sslContext(sslContext).sniHostName(cacheRemoteHost);
                }
                if (CacheManagerFactory.isRemoteAuthenticationEnabled()) {
                    storeBuilder.remoteSecurity().authentication().enable().username(CacheManagerFactory.requiredStringProperty("cache-remote-username")).password(CacheManagerFactory.requiredStringProperty("cache-remote-password")).realm("default").saslMechanism("SCRAM-SHA-512");
                }
            });
        }
    }

    private static void checkForRemoteStores(ConfigurationBuilderHolder builder) {
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE) && Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.MULTI_SITE)) {
            logger.fatalf("Feature %s is now deprecated.%nFor multi-site (cross-dc) support, enable only %s.", (Object)Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE.getKey(), (Object)Profile.Feature.MULTI_SITE.getKey());
            throw new RuntimeException("The features " + Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE.getKey() + " and " + Profile.Feature.MULTI_SITE.getKey() + " must not be enabled at the same time.");
        }
        if (Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE) && Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CLUSTERLESS)) {
            logger.fatalf("Feature %s is now deprecated.%nFor multi-site (cross-dc) support, enable only %s.", (Object)Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE.getKey(), (Object)Profile.Feature.CLUSTERLESS.getKey());
            throw new RuntimeException("The features " + Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE.getKey() + " and " + Profile.Feature.CLUSTERLESS.getKey() + " must not be enabled at the same time.");
        }
        if (!Profile.isFeatureEnabled((Profile.Feature)Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE) && builder.getNamedConfigurationBuilders().values().stream().anyMatch(CacheManagerFactory::hasRemoteStore)) {
            logger.fatalf("Remote stores are not supported for embedded caches as feature %s is not enabled. This feature is disabled by default as it is now deprecated.%nFor keeping user sessions across restarts, use feature %s which is enabled by default.%nFor multi-site (cross-dc) support, enable %s.", (Object)Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE.getKey(), (Object)Profile.Feature.PERSISTENT_USER_SESSIONS.getKey(), (Object)Profile.Feature.MULTI_SITE.getKey());
            throw new RuntimeException("Remote store is not supported as feature " + Profile.Feature.CACHE_EMBEDDED_REMOTE_STORE.getKey() + " is not enabled.");
        }
    }

    private static void configureSessionsCaches(ConfigurationBuilderHolder builder) {
        Stream.of("sessions", "clientSessions", "offlineSessions", "offlineClientSessions").forEach(cacheName -> {
            org.infinispan.configuration.cache.ConfigurationBuilder configurationBuilder = (org.infinispan.configuration.cache.ConfigurationBuilder)builder.getNamedConfigurationBuilders().get(cacheName);
            if (MultiSiteUtils.isPersistentSessionsEnabled()) {
                if (configurationBuilder.memory().maxCount() == -1L) {
                    logger.infof("Persistent user sessions enabled and no memory limit found in configuration. Setting max entries for %s to 10000 entries.", cacheName);
                    configurationBuilder.memory().maxCount(10000L);
                }
                configurationBuilder.clustering().hash().numOwners(1);
            } else {
                if (configurationBuilder.memory().maxCount() != -1L) {
                    logger.warnf("Persistent user sessions disabled and memory limit found in configuration for cache %s. This might be a misconfiguration! Update your Infinispan configuration to remove this message.", cacheName);
                }
                if (configurationBuilder.memory().maxCount() == 10000L && (cacheName.equals("sessions") || cacheName.equals("clientSessions"))) {
                    logger.warnf("Persistent user sessions disabled and memory limit is set to default value 10000. Ignoring cache limits to avoid losing sessions for cache %s.", cacheName);
                    configurationBuilder.memory().maxCount(-1L);
                }
                if ((Integer)configurationBuilder.clustering().hash().attributes().attribute(HashConfiguration.NUM_OWNERS).get() == 1 && configurationBuilder.persistence().stores().isEmpty()) {
                    logger.warnf("Number of owners is one for cache %s, and no persistence is configured. This might be a misconfiguration as you will lose data when a single node is restarted!", cacheName);
                }
            }
        });
    }

    private static void configureCacheMaxCount(ConfigurationBuilderHolder holder, String[] caches) {
        for (String cache : caches) {
            String propKey = CachingOptions.cacheMaxCountProperty((String)cache);
            org.keycloak.quarkus.runtime.configuration.Configuration.getOptionalKcValue(propKey).map(Integer::parseInt).ifPresent(maxCount -> ((org.infinispan.configuration.cache.ConfigurationBuilder)holder.getNamedConfigurationBuilders().get(cache)).memory().maxCount((long)maxCount.intValue()));
        }
    }

    private static String requiredStringProperty(String propertyName) {
        return org.keycloak.quarkus.runtime.configuration.Configuration.getOptionalKcValue(propertyName).orElseThrow(() -> new RuntimeException("Property " + propertyName + " required but not specified"));
    }

    private static boolean hasRemoteStore(org.infinispan.configuration.cache.ConfigurationBuilder builder) {
        return builder.persistence().stores().stream().anyMatch(RemoteStoreConfigurationBuilder.class::isInstance);
    }
}

