/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.quarkus.runtime.configuration;

import io.smallrye.config.AbstractLocationConfigSourceLoader;
import io.smallrye.config.PropertiesConfigSource;
import io.smallrye.config.common.utils.ConfigSourceUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.keycloak.quarkus.runtime.Environment;

public final class QuarkusPropertiesConfigSource
extends AbstractLocationConfigSourceLoader
implements ConfigSourceProvider {
    private static final String FILE_NAME = "quarkus.properties";
    public static final String NAME = "QuarkusProperties";
    private boolean loadingFile;

    public static Path getConfigurationFile() {
        File file;
        String homeDir = Environment.getHomeDir();
        if (homeDir != null && (file = Paths.get(homeDir, "conf", FILE_NAME).toFile()).exists()) {
            return file.toPath();
        }
        return null;
    }

    protected String[] getFileExtensions() {
        return new String[]{"properties"};
    }

    protected ConfigSource loadConfigSource(URL url, int ordinal) throws IOException {
        final String name = this.loadingFile ? NAME : "QuarkusProperties " + String.valueOf(url);
        return new PropertiesConfigSource(ConfigSourceUtil.urlToMap((URL)url), name, ordinal){

            public String getName() {
                return name;
            }

            public String getValue(String propertyName) {
                if (propertyName.startsWith("quarkus")) {
                    return super.getValue(propertyName);
                }
                return null;
            }
        };
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized List<ConfigSource> getConfigSources(ClassLoader classLoader) {
        ArrayList<ConfigSource> configSources = new ArrayList<ConfigSource>();
        configSources.addAll(this.loadConfigSources("META-INF/services/quarkus.properties", 450, classLoader));
        Path configFile = QuarkusPropertiesConfigSource.getConfigurationFile();
        if (configFile != null) {
            this.loadingFile = true;
            try {
                configSources.addAll(this.loadConfigSources(configFile.toUri().toString(), 475, classLoader));
            }
            finally {
                this.loadingFile = false;
            }
        }
        return configSources;
    }

    protected List<ConfigSource> tryClassPath(URI uri, int ordinal, ClassLoader classLoader) {
        try {
            return super.tryClassPath(uri, ordinal, classLoader);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof NoSuchFileException) {
                return Collections.emptyList();
            }
            throw e;
        }
    }
}

